package zio.aws.networkfirewall.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.networkfirewall.model.primitives.RuleVariableName
import scala.jdk.CollectionConverters._
final case class RuleVariables(
    ipSets: Option[Map[RuleVariableName, zio.aws.networkfirewall.model.IPSet]] =
      None,
    portSets: Option[
      Map[RuleVariableName, zio.aws.networkfirewall.model.PortSet]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.networkfirewall.model.RuleVariables = {
    import RuleVariables.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.networkfirewall.model.RuleVariables
      .builder()
      .optionallyWith(
        ipSets.map(value =>
          value
            .map({ case (key, value) =>
              (RuleVariableName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.ipSets)
      .optionallyWith(
        portSets.map(value =>
          value
            .map({ case (key, value) =>
              (RuleVariableName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.portSets)
      .build()
  }
  def asReadOnly: zio.aws.networkfirewall.model.RuleVariables.ReadOnly =
    zio.aws.networkfirewall.model.RuleVariables.wrap(buildAwsValue())
}
object RuleVariables {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.networkfirewall.model.RuleVariables
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.networkfirewall.model.RuleVariables =
      zio.aws.networkfirewall.model.RuleVariables(
        ipSets.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        portSets.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        )
      )
    def ipSets: Option[
      Map[RuleVariableName, zio.aws.networkfirewall.model.IPSet.ReadOnly]
    ]
    def portSets: Option[
      Map[RuleVariableName, zio.aws.networkfirewall.model.PortSet.ReadOnly]
    ]
    def getIpSets: ZIO[Any, AwsError, Map[
      RuleVariableName,
      zio.aws.networkfirewall.model.IPSet.ReadOnly
    ]] = AwsError.unwrapOptionField("ipSets", ipSets)
    def getPortSets: ZIO[Any, AwsError, Map[
      RuleVariableName,
      zio.aws.networkfirewall.model.PortSet.ReadOnly
    ]] = AwsError.unwrapOptionField("portSets", portSets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.networkfirewall.model.RuleVariables
  ) extends zio.aws.networkfirewall.model.RuleVariables.ReadOnly {
    override val ipSets: Option[
      Map[RuleVariableName, zio.aws.networkfirewall.model.IPSet.ReadOnly]
    ] = scala
      .Option(impl.ipSets())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.networkfirewall.model.primitives.RuleVariableName(
              key
            ) -> zio.aws.networkfirewall.model.IPSet.wrap(value)
          })
          .toMap
      )
    override val portSets: Option[
      Map[RuleVariableName, zio.aws.networkfirewall.model.PortSet.ReadOnly]
    ] = scala
      .Option(impl.portSets())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.networkfirewall.model.primitives.RuleVariableName(
              key
            ) -> zio.aws.networkfirewall.model.PortSet.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.networkfirewall.model.RuleVariables
  ): zio.aws.networkfirewall.model.RuleVariables.ReadOnly = new Wrapper(impl)
}
