package zio.aws.networkfirewall.model
import scala.jdk.CollectionConverters._
sealed trait TargetType {
  def unwrap: software.amazon.awssdk.services.networkfirewall.model.TargetType
}
object TargetType {
  def wrap(
      value: software.amazon.awssdk.services.networkfirewall.model.TargetType
  ): zio.aws.networkfirewall.model.TargetType = value match {
    case software.amazon.awssdk.services.networkfirewall.model.TargetType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.networkfirewall.model.TargetType.TLS_SNI =>
      val r = TLS_SNI
      r
    case software.amazon.awssdk.services.networkfirewall.model.TargetType.HTTP_HOST =>
      val r = HTTP_HOST
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.networkfirewall.model.TargetType {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.TargetType =
      software.amazon.awssdk.services.networkfirewall.model.TargetType.UNKNOWN_TO_SDK_VERSION
  }
  case object TLS_SNI extends zio.aws.networkfirewall.model.TargetType {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.TargetType =
      software.amazon.awssdk.services.networkfirewall.model.TargetType.TLS_SNI
  }
  case object HTTP_HOST extends zio.aws.networkfirewall.model.TargetType {
    override def unwrap
        : software.amazon.awssdk.services.networkfirewall.model.TargetType =
      software.amazon.awssdk.services.networkfirewall.model.TargetType.HTTP_HOST
  }
}
