package zio.aws.pinpointsmsvoicev2
import zio.aws.pinpointsmsvoicev2.model.ListTagsForResourceResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.pinpointsmsvoicev2.model.{
  CreateEventDestinationRequest,
  RequestPhoneNumberRequest,
  DeleteTextMessageSpendLimitOverrideRequest,
  SetDefaultMessageTypeRequest,
  DeleteDefaultSenderIdRequest,
  DescribeConfigurationSetsRequest,
  DescribePoolsRequest,
  DisassociateOriginationIdentityRequest,
  DeleteConfigurationSetRequest,
  ReleasePhoneNumberRequest,
  DeletePoolRequest,
  DeleteKeywordRequest,
  DescribePhoneNumbersRequest,
  UpdatePhoneNumberRequest,
  ListTagsForResourceRequest,
  DescribeKeywordsRequest,
  UpdatePoolRequest,
  CreateConfigurationSetRequest,
  CreatePoolRequest,
  DescribeSpendLimitsRequest,
  ListPoolOriginationIdentitiesRequest,
  SetDefaultSenderIdRequest,
  SendTextMessageRequest,
  SetTextMessageSpendLimitOverrideRequest,
  DescribeSenderIdsRequest,
  PutKeywordRequest,
  DeleteEventDestinationRequest,
  UntagResourceRequest,
  DescribeOptOutListsRequest,
  DescribeAccountAttributesRequest,
  PutOptedOutNumberRequest,
  DeleteVoiceMessageSpendLimitOverrideRequest,
  SendVoiceMessageRequest,
  DescribeAccountLimitsRequest,
  CreateOptOutListRequest,
  AssociateOriginationIdentityRequest,
  DeleteDefaultMessageTypeRequest,
  UpdateEventDestinationRequest,
  TagResourceRequest,
  DeleteOptOutListRequest,
  DeleteOptedOutNumberRequest,
  DescribeOptedOutNumbersRequest,
  SetVoiceMessageSpendLimitOverrideRequest
}
import zio.aws.core.{StreamingOutputResult, AwsError}
import zio.aws.core.aspects.AwsCallAspect
import software.amazon.awssdk.services.pinpointsmsvoicev2.PinpointSmsVoiceV2AsyncClient
import zio.{ZIO, IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object PinpointSmsVoiceV2Mock extends Mock[PinpointSmsVoiceV2] {
  object DeleteKeyword
      extends Effect[
        DeleteKeywordRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.DeleteKeywordResponse.ReadOnly
      ]
  object DeleteOptedOutNumber
      extends Effect[
        DeleteOptedOutNumberRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.DeleteOptedOutNumberResponse.ReadOnly
      ]
  object RequestPhoneNumber
      extends Effect[
        RequestPhoneNumberRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.RequestPhoneNumberResponse.ReadOnly
      ]
  object DeleteDefaultSenderId
      extends Effect[
        DeleteDefaultSenderIdRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.DeleteDefaultSenderIdResponse.ReadOnly
      ]
  object DescribeKeywords
      extends Effect[DescribeKeywordsRequest, AwsError, StreamingOutputResult[
        Any,
        zio.aws.pinpointsmsvoicev2.model.DescribeKeywordsResponse.ReadOnly,
        zio.aws.pinpointsmsvoicev2.model.KeywordInformation.ReadOnly
      ]]
  object DescribeKeywordsPaginated
      extends Effect[
        DescribeKeywordsRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.DescribeKeywordsResponse.ReadOnly
      ]
  object SendTextMessage
      extends Effect[
        SendTextMessageRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.SendTextMessageResponse.ReadOnly
      ]
  object ReleasePhoneNumber
      extends Effect[
        ReleasePhoneNumberRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.ReleasePhoneNumberResponse.ReadOnly
      ]
  object DescribePools
      extends Stream[
        DescribePoolsRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.PoolInformation.ReadOnly
      ]
  object DescribePoolsPaginated
      extends Effect[
        DescribePoolsRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.DescribePoolsResponse.ReadOnly
      ]
  object DescribeOptOutLists
      extends Stream[
        DescribeOptOutListsRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.OptOutListInformation.ReadOnly
      ]
  object DescribeOptOutListsPaginated
      extends Effect[
        DescribeOptOutListsRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.DescribeOptOutListsResponse.ReadOnly
      ]
  object DeleteEventDestination
      extends Effect[
        DeleteEventDestinationRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.DeleteEventDestinationResponse.ReadOnly
      ]
  object CreateOptOutList
      extends Effect[
        CreateOptOutListRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.CreateOptOutListResponse.ReadOnly
      ]
  object DescribeAccountLimits
      extends Stream[
        DescribeAccountLimitsRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.AccountLimit.ReadOnly
      ]
  object DescribeAccountLimitsPaginated
      extends Effect[
        DescribeAccountLimitsRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.DescribeAccountLimitsResponse.ReadOnly
      ]
  object ListPoolOriginationIdentities
      extends Effect[
        ListPoolOriginationIdentitiesRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse.ReadOnly,
          zio.aws.pinpointsmsvoicev2.model.OriginationIdentityMetadata.ReadOnly
        ]
      ]
  object ListPoolOriginationIdentitiesPaginated
      extends Effect[
        ListPoolOriginationIdentitiesRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse.ReadOnly
      ]
  object DeleteTextMessageSpendLimitOverride
      extends Effect[
        DeleteTextMessageSpendLimitOverrideRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.DeleteTextMessageSpendLimitOverrideResponse.ReadOnly
      ]
  object CreatePool
      extends Effect[
        CreatePoolRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.CreatePoolResponse.ReadOnly
      ]
  object UpdatePhoneNumber
      extends Effect[
        UpdatePhoneNumberRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.UpdatePhoneNumberResponse.ReadOnly
      ]
  object PutOptedOutNumber
      extends Effect[
        PutOptedOutNumberRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.PutOptedOutNumberResponse.ReadOnly
      ]
  object PutKeyword
      extends Effect[
        PutKeywordRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.PutKeywordResponse.ReadOnly
      ]
  object UpdatePool
      extends Effect[
        UpdatePoolRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.UpdatePoolResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.UntagResourceResponse.ReadOnly
      ]
  object DeleteDefaultMessageType
      extends Effect[
        DeleteDefaultMessageTypeRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.DeleteDefaultMessageTypeResponse.ReadOnly
      ]
  object DescribeSenderIds
      extends Stream[
        DescribeSenderIdsRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.SenderIdInformation.ReadOnly
      ]
  object DescribeSenderIdsPaginated
      extends Effect[
        DescribeSenderIdsRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.DescribeSenderIdsResponse.ReadOnly
      ]
  object DeletePool
      extends Effect[
        DeletePoolRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.DeletePoolResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[ListTagsForResourceRequest, AwsError, ReadOnly]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.TagResourceResponse.ReadOnly
      ]
  object DescribeConfigurationSets
      extends Stream[
        DescribeConfigurationSetsRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.ConfigurationSetInformation.ReadOnly
      ]
  object DescribeConfigurationSetsPaginated
      extends Effect[
        DescribeConfigurationSetsRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.DescribeConfigurationSetsResponse.ReadOnly
      ]
  object SetVoiceMessageSpendLimitOverride
      extends Effect[
        SetVoiceMessageSpendLimitOverrideRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.SetVoiceMessageSpendLimitOverrideResponse.ReadOnly
      ]
  object DeleteConfigurationSet
      extends Effect[
        DeleteConfigurationSetRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.DeleteConfigurationSetResponse.ReadOnly
      ]
  object CreateConfigurationSet
      extends Effect[
        CreateConfigurationSetRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.CreateConfigurationSetResponse.ReadOnly
      ]
  object DeleteOptOutList
      extends Effect[
        DeleteOptOutListRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.DeleteOptOutListResponse.ReadOnly
      ]
  object SendVoiceMessage
      extends Effect[
        SendVoiceMessageRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.SendVoiceMessageResponse.ReadOnly
      ]
  object DisassociateOriginationIdentity
      extends Effect[
        DisassociateOriginationIdentityRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.DisassociateOriginationIdentityResponse.ReadOnly
      ]
  object CreateEventDestination
      extends Effect[
        CreateEventDestinationRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.CreateEventDestinationResponse.ReadOnly
      ]
  object DescribeSpendLimits
      extends Stream[
        DescribeSpendLimitsRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.SpendLimit.ReadOnly
      ]
  object DescribeSpendLimitsPaginated
      extends Effect[
        DescribeSpendLimitsRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.DescribeSpendLimitsResponse.ReadOnly
      ]
  object DescribePhoneNumbers
      extends Stream[
        DescribePhoneNumbersRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.PhoneNumberInformation.ReadOnly
      ]
  object DescribePhoneNumbersPaginated
      extends Effect[
        DescribePhoneNumbersRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.DescribePhoneNumbersResponse.ReadOnly
      ]
  object DescribeAccountAttributes
      extends Stream[
        DescribeAccountAttributesRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.AccountAttribute.ReadOnly
      ]
  object DescribeAccountAttributesPaginated
      extends Effect[
        DescribeAccountAttributesRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.DescribeAccountAttributesResponse.ReadOnly
      ]
  object SetDefaultSenderId
      extends Effect[
        SetDefaultSenderIdRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.SetDefaultSenderIdResponse.ReadOnly
      ]
  object DeleteVoiceMessageSpendLimitOverride
      extends Effect[
        DeleteVoiceMessageSpendLimitOverrideRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.DeleteVoiceMessageSpendLimitOverrideResponse.ReadOnly
      ]
  object SetTextMessageSpendLimitOverride
      extends Effect[
        SetTextMessageSpendLimitOverrideRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.SetTextMessageSpendLimitOverrideResponse.ReadOnly
      ]
  object AssociateOriginationIdentity
      extends Effect[
        AssociateOriginationIdentityRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.AssociateOriginationIdentityResponse.ReadOnly
      ]
  object UpdateEventDestination
      extends Effect[
        UpdateEventDestinationRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.UpdateEventDestinationResponse.ReadOnly
      ]
  object DescribeOptedOutNumbers
      extends Effect[
        DescribeOptedOutNumbersRequest,
        AwsError,
        StreamingOutputResult[
          Any,
          zio.aws.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse.ReadOnly,
          zio.aws.pinpointsmsvoicev2.model.OptedOutNumberInformation.ReadOnly
        ]
      ]
  object DescribeOptedOutNumbersPaginated
      extends Effect[
        DescribeOptedOutNumbersRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse.ReadOnly
      ]
  object SetDefaultMessageType
      extends Effect[
        SetDefaultMessageTypeRequest,
        AwsError,
        zio.aws.pinpointsmsvoicev2.model.SetDefaultMessageTypeResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, PinpointSmsVoiceV2] = zio.ZLayer {
    ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new PinpointSmsVoiceV2 {
          val api: PinpointSmsVoiceV2AsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : PinpointSmsVoiceV2 = this
          def deleteKeyword(request: DeleteKeywordRequest): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.DeleteKeywordResponse.ReadOnly
          ] = proxy(DeleteKeyword, request)
          def deleteOptedOutNumber(request: DeleteOptedOutNumberRequest): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.DeleteOptedOutNumberResponse.ReadOnly
          ] = proxy(DeleteOptedOutNumber, request)
          def requestPhoneNumber(request: RequestPhoneNumberRequest): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.RequestPhoneNumberResponse.ReadOnly
          ] = proxy(RequestPhoneNumber, request)
          def deleteDefaultSenderId(request: DeleteDefaultSenderIdRequest): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.DeleteDefaultSenderIdResponse.ReadOnly
          ] = proxy(DeleteDefaultSenderId, request)
          def describeKeywords(
              request: DescribeKeywordsRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.pinpointsmsvoicev2.model.DescribeKeywordsResponse.ReadOnly,
            zio.aws.pinpointsmsvoicev2.model.KeywordInformation.ReadOnly
          ]] = proxy(DescribeKeywords, request)
          def describeKeywordsPaginated(request: DescribeKeywordsRequest): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.DescribeKeywordsResponse.ReadOnly
          ] = proxy(DescribeKeywordsPaginated, request)
          def sendTextMessage(request: SendTextMessageRequest): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.SendTextMessageResponse.ReadOnly
          ] = proxy(SendTextMessage, request)
          def releasePhoneNumber(request: ReleasePhoneNumberRequest): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.ReleasePhoneNumberResponse.ReadOnly
          ] = proxy(ReleasePhoneNumber, request)
          def describePools(request: DescribePoolsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.PoolInformation.ReadOnly
          ] = rts.unsafeRun(proxy(DescribePools, request))
          def describePoolsPaginated(request: DescribePoolsRequest): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.DescribePoolsResponse.ReadOnly
          ] = proxy(DescribePoolsPaginated, request)
          def describeOptOutLists(request: DescribeOptOutListsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.OptOutListInformation.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeOptOutLists, request))
          def describeOptOutListsPaginated(
              request: DescribeOptOutListsRequest
          ): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.DescribeOptOutListsResponse.ReadOnly
          ] = proxy(DescribeOptOutListsPaginated, request)
          def deleteEventDestination(
              request: DeleteEventDestinationRequest
          ): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.DeleteEventDestinationResponse.ReadOnly
          ] = proxy(DeleteEventDestination, request)
          def createOptOutList(request: CreateOptOutListRequest): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.CreateOptOutListResponse.ReadOnly
          ] = proxy(CreateOptOutList, request)
          def describeAccountLimits(
              request: DescribeAccountLimitsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.AccountLimit.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeAccountLimits, request))
          def describeAccountLimitsPaginated(
              request: DescribeAccountLimitsRequest
          ): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.DescribeAccountLimitsResponse.ReadOnly
          ] = proxy(DescribeAccountLimitsPaginated, request)
          def listPoolOriginationIdentities(
              request: ListPoolOriginationIdentitiesRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse.ReadOnly,
            zio.aws.pinpointsmsvoicev2.model.OriginationIdentityMetadata.ReadOnly
          ]] = proxy(ListPoolOriginationIdentities, request)
          def listPoolOriginationIdentitiesPaginated(
              request: ListPoolOriginationIdentitiesRequest
          ): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse.ReadOnly
          ] = proxy(ListPoolOriginationIdentitiesPaginated, request)
          def deleteTextMessageSpendLimitOverride(
              request: DeleteTextMessageSpendLimitOverrideRequest
          ): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.DeleteTextMessageSpendLimitOverrideResponse.ReadOnly
          ] = proxy(DeleteTextMessageSpendLimitOverride, request)
          def createPool(request: CreatePoolRequest): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.CreatePoolResponse.ReadOnly
          ] = proxy(CreatePool, request)
          def updatePhoneNumber(request: UpdatePhoneNumberRequest): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.UpdatePhoneNumberResponse.ReadOnly
          ] = proxy(UpdatePhoneNumber, request)
          def putOptedOutNumber(request: PutOptedOutNumberRequest): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.PutOptedOutNumberResponse.ReadOnly
          ] = proxy(PutOptedOutNumber, request)
          def putKeyword(request: PutKeywordRequest): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.PutKeywordResponse.ReadOnly
          ] = proxy(PutKeyword, request)
          def updatePool(request: UpdatePoolRequest): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.UpdatePoolResponse.ReadOnly
          ] = proxy(UpdatePool, request)
          def untagResource(request: UntagResourceRequest): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.UntagResourceResponse.ReadOnly
          ] = proxy(UntagResource, request)
          def deleteDefaultMessageType(
              request: DeleteDefaultMessageTypeRequest
          ): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.DeleteDefaultMessageTypeResponse.ReadOnly
          ] = proxy(DeleteDefaultMessageType, request)
          def describeSenderIds(request: DescribeSenderIdsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.SenderIdInformation.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeSenderIds, request))
          def describeSenderIdsPaginated(request: DescribeSenderIdsRequest): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.DescribeSenderIdsResponse.ReadOnly
          ] = proxy(DescribeSenderIdsPaginated, request)
          def deletePool(request: DeletePoolRequest): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.DeletePoolResponse.ReadOnly
          ] = proxy(DeletePool, request)
          def listTagsForResource(
              request: ListTagsForResourceRequest
          ): IO[AwsError, ReadOnly] = proxy(ListTagsForResource, request)
          def tagResource(request: TagResourceRequest): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.TagResourceResponse.ReadOnly
          ] = proxy(TagResource, request)
          def describeConfigurationSets(
              request: DescribeConfigurationSetsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.ConfigurationSetInformation.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeConfigurationSets, request))
          def describeConfigurationSetsPaginated(
              request: DescribeConfigurationSetsRequest
          ): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.DescribeConfigurationSetsResponse.ReadOnly
          ] = proxy(DescribeConfigurationSetsPaginated, request)
          def setVoiceMessageSpendLimitOverride(
              request: SetVoiceMessageSpendLimitOverrideRequest
          ): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.SetVoiceMessageSpendLimitOverrideResponse.ReadOnly
          ] = proxy(SetVoiceMessageSpendLimitOverride, request)
          def deleteConfigurationSet(
              request: DeleteConfigurationSetRequest
          ): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.DeleteConfigurationSetResponse.ReadOnly
          ] = proxy(DeleteConfigurationSet, request)
          def createConfigurationSet(
              request: CreateConfigurationSetRequest
          ): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.CreateConfigurationSetResponse.ReadOnly
          ] = proxy(CreateConfigurationSet, request)
          def deleteOptOutList(request: DeleteOptOutListRequest): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.DeleteOptOutListResponse.ReadOnly
          ] = proxy(DeleteOptOutList, request)
          def sendVoiceMessage(request: SendVoiceMessageRequest): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.SendVoiceMessageResponse.ReadOnly
          ] = proxy(SendVoiceMessage, request)
          def disassociateOriginationIdentity(
              request: DisassociateOriginationIdentityRequest
          ): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.DisassociateOriginationIdentityResponse.ReadOnly
          ] = proxy(DisassociateOriginationIdentity, request)
          def createEventDestination(
              request: CreateEventDestinationRequest
          ): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.CreateEventDestinationResponse.ReadOnly
          ] = proxy(CreateEventDestination, request)
          def describeSpendLimits(request: DescribeSpendLimitsRequest): ZStream[
            Any,
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.SpendLimit.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeSpendLimits, request))
          def describeSpendLimitsPaginated(
              request: DescribeSpendLimitsRequest
          ): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.DescribeSpendLimitsResponse.ReadOnly
          ] = proxy(DescribeSpendLimitsPaginated, request)
          def describePhoneNumbers(
              request: DescribePhoneNumbersRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.PhoneNumberInformation.ReadOnly
          ] = rts.unsafeRun(proxy(DescribePhoneNumbers, request))
          def describePhoneNumbersPaginated(
              request: DescribePhoneNumbersRequest
          ): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.DescribePhoneNumbersResponse.ReadOnly
          ] = proxy(DescribePhoneNumbersPaginated, request)
          def describeAccountAttributes(
              request: DescribeAccountAttributesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.AccountAttribute.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeAccountAttributes, request))
          def describeAccountAttributesPaginated(
              request: DescribeAccountAttributesRequest
          ): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.DescribeAccountAttributesResponse.ReadOnly
          ] = proxy(DescribeAccountAttributesPaginated, request)
          def setDefaultSenderId(request: SetDefaultSenderIdRequest): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.SetDefaultSenderIdResponse.ReadOnly
          ] = proxy(SetDefaultSenderId, request)
          def deleteVoiceMessageSpendLimitOverride(
              request: DeleteVoiceMessageSpendLimitOverrideRequest
          ): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.DeleteVoiceMessageSpendLimitOverrideResponse.ReadOnly
          ] = proxy(DeleteVoiceMessageSpendLimitOverride, request)
          def setTextMessageSpendLimitOverride(
              request: SetTextMessageSpendLimitOverrideRequest
          ): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.SetTextMessageSpendLimitOverrideResponse.ReadOnly
          ] = proxy(SetTextMessageSpendLimitOverride, request)
          def associateOriginationIdentity(
              request: AssociateOriginationIdentityRequest
          ): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.AssociateOriginationIdentityResponse.ReadOnly
          ] = proxy(AssociateOriginationIdentity, request)
          def updateEventDestination(
              request: UpdateEventDestinationRequest
          ): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.UpdateEventDestinationResponse.ReadOnly
          ] = proxy(UpdateEventDestination, request)
          def describeOptedOutNumbers(
              request: DescribeOptedOutNumbersRequest
          ): ZIO[Any, AwsError, StreamingOutputResult[
            Any,
            zio.aws.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse.ReadOnly,
            zio.aws.pinpointsmsvoicev2.model.OptedOutNumberInformation.ReadOnly
          ]] = proxy(DescribeOptedOutNumbers, request)
          def describeOptedOutNumbersPaginated(
              request: DescribeOptedOutNumbersRequest
          ): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse.ReadOnly
          ] = proxy(DescribeOptedOutNumbersPaginated, request)
          def setDefaultMessageType(request: SetDefaultMessageTypeRequest): IO[
            AwsError,
            zio.aws.pinpointsmsvoicev2.model.SetDefaultMessageTypeResponse.ReadOnly
          ] = proxy(SetDefaultMessageType, request)
        }
      }
    }
  }
}
