package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AccountAttribute(
    name: zio.aws.pinpointsmsvoicev2.model.AccountAttributeName,
    value: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.AccountAttribute = {
    import AccountAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.AccountAttribute
      .builder()
      .name(name.unwrap)
      .value(value: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.pinpointsmsvoicev2.model.AccountAttribute.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.AccountAttribute.wrap(buildAwsValue())
}
object AccountAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.AccountAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.AccountAttribute =
      zio.aws.pinpointsmsvoicev2.model.AccountAttribute(name, value)
    def name: zio.aws.pinpointsmsvoicev2.model.AccountAttributeName
    def value: String
    def getName: ZIO[
      Any,
      Nothing,
      zio.aws.pinpointsmsvoicev2.model.AccountAttributeName
    ] = ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, String] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.AccountAttribute
  ) extends zio.aws.pinpointsmsvoicev2.model.AccountAttribute.ReadOnly {
    override val name: zio.aws.pinpointsmsvoicev2.model.AccountAttributeName =
      zio.aws.pinpointsmsvoicev2.model.AccountAttributeName.wrap(impl.name())
    override val value: String = impl.value(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.AccountAttribute
  ): zio.aws.pinpointsmsvoicev2.model.AccountAttribute.ReadOnly = new Wrapper(
    impl
  )
}
