package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.PrimitiveLong
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AccountLimit(
    name: zio.aws.pinpointsmsvoicev2.model.AccountLimitName,
    used: PrimitiveLong,
    max: PrimitiveLong
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.AccountLimit = {
    import AccountLimit.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.AccountLimit
      .builder()
      .name(name.unwrap)
      .used(PrimitiveLong.unwrap(used): java.lang.Long)
      .max(PrimitiveLong.unwrap(max): java.lang.Long)
      .build()
  }
  def asReadOnly: zio.aws.pinpointsmsvoicev2.model.AccountLimit.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.AccountLimit.wrap(buildAwsValue())
}
object AccountLimit {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.AccountLimit
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.AccountLimit =
      zio.aws.pinpointsmsvoicev2.model.AccountLimit(name, used, max)
    def name: zio.aws.pinpointsmsvoicev2.model.AccountLimitName
    def used: PrimitiveLong
    def max: PrimitiveLong
    def getName
        : ZIO[Any, Nothing, zio.aws.pinpointsmsvoicev2.model.AccountLimitName] =
      ZIO.succeed(name)
    def getUsed: ZIO[Any, Nothing, PrimitiveLong] = ZIO.succeed(used)
    def getMax: ZIO[Any, Nothing, PrimitiveLong] = ZIO.succeed(max)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.AccountLimit
  ) extends zio.aws.pinpointsmsvoicev2.model.AccountLimit.ReadOnly {
    override val name: zio.aws.pinpointsmsvoicev2.model.AccountLimitName =
      zio.aws.pinpointsmsvoicev2.model.AccountLimitName.wrap(impl.name())
    override val used: PrimitiveLong =
      zio.aws.pinpointsmsvoicev2.model.primitives.PrimitiveLong(impl.used())
    override val max: PrimitiveLong =
      zio.aws.pinpointsmsvoicev2.model.primitives.PrimitiveLong(impl.max())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.AccountLimit
  ): zio.aws.pinpointsmsvoicev2.model.AccountLimit.ReadOnly = new Wrapper(impl)
}
