package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.{
  ClientToken,
  IsoCountryCode,
  PhoneOrSenderIdOrArn,
  PoolIdOrArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AssociateOriginationIdentityRequest(
    poolId: PoolIdOrArn,
    originationIdentity: PhoneOrSenderIdOrArn,
    isoCountryCode: IsoCountryCode,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.AssociateOriginationIdentityRequest = {
    import AssociateOriginationIdentityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.AssociateOriginationIdentityRequest
      .builder()
      .poolId(PoolIdOrArn.unwrap(poolId): java.lang.String)
      .originationIdentity(
        PhoneOrSenderIdOrArn.unwrap(originationIdentity): java.lang.String
      )
      .isoCountryCode(IsoCountryCode.unwrap(isoCountryCode): java.lang.String)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.AssociateOriginationIdentityRequest.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.AssociateOriginationIdentityRequest
      .wrap(buildAwsValue())
}
object AssociateOriginationIdentityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.AssociateOriginationIdentityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointsmsvoicev2.model.AssociateOriginationIdentityRequest =
      zio.aws.pinpointsmsvoicev2.model.AssociateOriginationIdentityRequest(
        poolId,
        originationIdentity,
        isoCountryCode,
        clientToken.map(value => value)
      )
    def poolId: PoolIdOrArn
    def originationIdentity: PhoneOrSenderIdOrArn
    def isoCountryCode: IsoCountryCode
    def clientToken: Optional[ClientToken]
    def getPoolId: ZIO[Any, Nothing, PoolIdOrArn] = ZIO.succeed(poolId)
    def getOriginationIdentity: ZIO[Any, Nothing, PhoneOrSenderIdOrArn] =
      ZIO.succeed(originationIdentity)
    def getIsoCountryCode: ZIO[Any, Nothing, IsoCountryCode] =
      ZIO.succeed(isoCountryCode)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.AssociateOriginationIdentityRequest
  ) extends zio.aws.pinpointsmsvoicev2.model.AssociateOriginationIdentityRequest.ReadOnly {
    override val poolId: PoolIdOrArn =
      zio.aws.pinpointsmsvoicev2.model.primitives.PoolIdOrArn(impl.poolId())
    override val originationIdentity: PhoneOrSenderIdOrArn =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .PhoneOrSenderIdOrArn(impl.originationIdentity())
    override val isoCountryCode: IsoCountryCode =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .IsoCountryCode(impl.isoCountryCode())
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.ClientToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.AssociateOriginationIdentityRequest
  ): zio.aws.pinpointsmsvoicev2.model.AssociateOriginationIdentityRequest.ReadOnly =
    new Wrapper(impl)
}
