package zio.aws.pinpointsmsvoicev2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointsmsvoicev2.model.primitives.{
  Timestamp,
  SenderId,
  ConfigurationSetName
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ConfigurationSetInformation(
    configurationSetArn: String,
    configurationSetName: ConfigurationSetName,
    eventDestinations: Iterable[
      zio.aws.pinpointsmsvoicev2.model.EventDestination
    ],
    defaultMessageType: Optional[zio.aws.pinpointsmsvoicev2.model.MessageType] =
      Optional.Absent,
    defaultSenderId: Optional[SenderId] = Optional.Absent,
    createdTimestamp: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.ConfigurationSetInformation = {
    import ConfigurationSetInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.ConfigurationSetInformation
      .builder()
      .configurationSetArn(configurationSetArn: java.lang.String)
      .configurationSetName(
        ConfigurationSetName.unwrap(configurationSetName): java.lang.String
      )
      .eventDestinations(eventDestinations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(defaultMessageType.map(value => value.unwrap))(
        _.defaultMessageType
      )
      .optionallyWith(
        defaultSenderId.map(value => SenderId.unwrap(value): java.lang.String)
      )(_.defaultSenderId)
      .createdTimestamp(Timestamp.unwrap(createdTimestamp): Instant)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.ConfigurationSetInformation.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.ConfigurationSetInformation
      .wrap(buildAwsValue())
}
object ConfigurationSetInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.ConfigurationSetInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointsmsvoicev2.model.ConfigurationSetInformation =
      zio.aws.pinpointsmsvoicev2.model.ConfigurationSetInformation(
        configurationSetArn,
        configurationSetName,
        eventDestinations.map { item =>
          item.asEditable
        },
        defaultMessageType.map(value => value),
        defaultSenderId.map(value => value),
        createdTimestamp
      )
    def configurationSetArn: String
    def configurationSetName: ConfigurationSetName
    def eventDestinations
        : List[zio.aws.pinpointsmsvoicev2.model.EventDestination.ReadOnly]
    def defaultMessageType
        : Optional[zio.aws.pinpointsmsvoicev2.model.MessageType]
    def defaultSenderId: Optional[SenderId]
    def createdTimestamp: Timestamp
    def getConfigurationSetArn: ZIO[Any, Nothing, String] =
      ZIO.succeed(configurationSetArn)
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetName] =
      ZIO.succeed(configurationSetName)
    def getEventDestinations: ZIO[Any, Nothing, List[
      zio.aws.pinpointsmsvoicev2.model.EventDestination.ReadOnly
    ]] = ZIO.succeed(eventDestinations)
    def getDefaultMessageType
        : ZIO[Any, AwsError, zio.aws.pinpointsmsvoicev2.model.MessageType] =
      AwsError.unwrapOptionField("defaultMessageType", defaultMessageType)
    def getDefaultSenderId: ZIO[Any, AwsError, SenderId] =
      AwsError.unwrapOptionField("defaultSenderId", defaultSenderId)
    def getCreatedTimestamp: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(createdTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.ConfigurationSetInformation
  ) extends zio.aws.pinpointsmsvoicev2.model.ConfigurationSetInformation.ReadOnly {
    override val configurationSetArn: String =
      impl.configurationSetArn(): String
    override val configurationSetName: ConfigurationSetName =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .ConfigurationSetName(impl.configurationSetName())
    override val eventDestinations
        : List[zio.aws.pinpointsmsvoicev2.model.EventDestination.ReadOnly] =
      impl
        .eventDestinations()
        .asScala
        .map { item =>
          zio.aws.pinpointsmsvoicev2.model.EventDestination.wrap(item)
        }
        .toList
    override val defaultMessageType
        : Optional[zio.aws.pinpointsmsvoicev2.model.MessageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultMessageType())
        .map(value => zio.aws.pinpointsmsvoicev2.model.MessageType.wrap(value))
    override val defaultSenderId: Optional[SenderId] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultSenderId())
      .map(value => zio.aws.pinpointsmsvoicev2.model.primitives.SenderId(value))
    override val createdTimestamp: Timestamp =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .Timestamp(impl.createdTimestamp())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.ConfigurationSetInformation
  ): zio.aws.pinpointsmsvoicev2.model.ConfigurationSetInformation.ReadOnly =
    new Wrapper(impl)
}
