package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.{
  ClientToken,
  EventDestinationName,
  ConfigurationSetNameOrArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateEventDestinationRequest(
    configurationSetName: ConfigurationSetNameOrArn,
    eventDestinationName: EventDestinationName,
    matchingEventTypes: Iterable[zio.aws.pinpointsmsvoicev2.model.EventType],
    cloudWatchLogsDestination: Optional[
      zio.aws.pinpointsmsvoicev2.model.CloudWatchLogsDestination
    ] = Optional.Absent,
    kinesisFirehoseDestination: Optional[
      zio.aws.pinpointsmsvoicev2.model.KinesisFirehoseDestination
    ] = Optional.Absent,
    snsDestination: Optional[zio.aws.pinpointsmsvoicev2.model.SnsDestination] =
      Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateEventDestinationRequest = {
    import CreateEventDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateEventDestinationRequest
      .builder()
      .configurationSetName(
        ConfigurationSetNameOrArn.unwrap(configurationSetName): java.lang.String
      )
      .eventDestinationName(
        EventDestinationName.unwrap(eventDestinationName): java.lang.String
      )
      .matchingEventTypesWithStrings(matchingEventTypes.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(
        cloudWatchLogsDestination.map(value => value.buildAwsValue())
      )(_.cloudWatchLogsDestination)
      .optionallyWith(
        kinesisFirehoseDestination.map(value => value.buildAwsValue())
      )(_.kinesisFirehoseDestination)
      .optionallyWith(snsDestination.map(value => value.buildAwsValue()))(
        _.snsDestination
      )
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.CreateEventDestinationRequest.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.CreateEventDestinationRequest
      .wrap(buildAwsValue())
}
object CreateEventDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateEventDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointsmsvoicev2.model.CreateEventDestinationRequest =
      zio.aws.pinpointsmsvoicev2.model.CreateEventDestinationRequest(
        configurationSetName,
        eventDestinationName,
        matchingEventTypes,
        cloudWatchLogsDestination.map(value => value.asEditable),
        kinesisFirehoseDestination.map(value => value.asEditable),
        snsDestination.map(value => value.asEditable),
        clientToken.map(value => value)
      )
    def configurationSetName: ConfigurationSetNameOrArn
    def eventDestinationName: EventDestinationName
    def matchingEventTypes: List[zio.aws.pinpointsmsvoicev2.model.EventType]
    def cloudWatchLogsDestination: Optional[
      zio.aws.pinpointsmsvoicev2.model.CloudWatchLogsDestination.ReadOnly
    ]
    def kinesisFirehoseDestination: Optional[
      zio.aws.pinpointsmsvoicev2.model.KinesisFirehoseDestination.ReadOnly
    ]
    def snsDestination
        : Optional[zio.aws.pinpointsmsvoicev2.model.SnsDestination.ReadOnly]
    def clientToken: Optional[ClientToken]
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetNameOrArn] =
      ZIO.succeed(configurationSetName)
    def getEventDestinationName: ZIO[Any, Nothing, EventDestinationName] =
      ZIO.succeed(eventDestinationName)
    def getMatchingEventTypes
        : ZIO[Any, Nothing, List[zio.aws.pinpointsmsvoicev2.model.EventType]] =
      ZIO.succeed(matchingEventTypes)
    def getCloudWatchLogsDestination: ZIO[
      Any,
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.CloudWatchLogsDestination.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchLogsDestination",
      cloudWatchLogsDestination
    )
    def getKinesisFirehoseDestination: ZIO[
      Any,
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.KinesisFirehoseDestination.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kinesisFirehoseDestination",
      kinesisFirehoseDestination
    )
    def getSnsDestination: ZIO[
      Any,
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.SnsDestination.ReadOnly
    ] = AwsError.unwrapOptionField("snsDestination", snsDestination)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateEventDestinationRequest
  ) extends zio.aws.pinpointsmsvoicev2.model.CreateEventDestinationRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetNameOrArn =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .ConfigurationSetNameOrArn(impl.configurationSetName())
    override val eventDestinationName: EventDestinationName =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .EventDestinationName(impl.eventDestinationName())
    override val matchingEventTypes
        : List[zio.aws.pinpointsmsvoicev2.model.EventType] = impl
      .matchingEventTypes()
      .asScala
      .map { item =>
        zio.aws.pinpointsmsvoicev2.model.EventType.wrap(item)
      }
      .toList
    override val cloudWatchLogsDestination: Optional[
      zio.aws.pinpointsmsvoicev2.model.CloudWatchLogsDestination.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudWatchLogsDestination())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.CloudWatchLogsDestination.wrap(value)
      )
    override val kinesisFirehoseDestination: Optional[
      zio.aws.pinpointsmsvoicev2.model.KinesisFirehoseDestination.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.kinesisFirehoseDestination())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.KinesisFirehoseDestination.wrap(value)
      )
    override val snsDestination
        : Optional[zio.aws.pinpointsmsvoicev2.model.SnsDestination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snsDestination())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.SnsDestination.wrap(value)
        )
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.ClientToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateEventDestinationRequest
  ): zio.aws.pinpointsmsvoicev2.model.CreateEventDestinationRequest.ReadOnly =
    new Wrapper(impl)
}
