package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.{ClientToken, OptOutListName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateOptOutListRequest(
    optOutListName: OptOutListName,
    tags: Optional[Iterable[zio.aws.pinpointsmsvoicev2.model.Tag]] =
      Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateOptOutListRequest = {
    import CreateOptOutListRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateOptOutListRequest
      .builder()
      .optOutListName(OptOutListName.unwrap(optOutListName): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.CreateOptOutListRequest.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.CreateOptOutListRequest
      .wrap(buildAwsValue())
}
object CreateOptOutListRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateOptOutListRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.CreateOptOutListRequest =
      zio.aws.pinpointsmsvoicev2.model.CreateOptOutListRequest(
        optOutListName,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken.map(value => value)
      )
    def optOutListName: OptOutListName
    def tags: Optional[List[zio.aws.pinpointsmsvoicev2.model.Tag.ReadOnly]]
    def clientToken: Optional[ClientToken]
    def getOptOutListName: ZIO[Any, Nothing, OptOutListName] =
      ZIO.succeed(optOutListName)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.pinpointsmsvoicev2.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateOptOutListRequest
  ) extends zio.aws.pinpointsmsvoicev2.model.CreateOptOutListRequest.ReadOnly {
    override val optOutListName: OptOutListName =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .OptOutListName(impl.optOutListName())
    override val tags
        : Optional[List[zio.aws.pinpointsmsvoicev2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpointsmsvoicev2.model.Tag.wrap(item)
          }.toList
        )
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.ClientToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateOptOutListRequest
  ): zio.aws.pinpointsmsvoicev2.model.CreateOptOutListRequest.ReadOnly =
    new Wrapper(impl)
}
