package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.{
  ClientToken,
  IsoCountryCode,
  PhoneOrSenderIdOrArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreatePoolRequest(
    originationIdentity: PhoneOrSenderIdOrArn,
    isoCountryCode: IsoCountryCode,
    messageType: zio.aws.pinpointsmsvoicev2.model.MessageType,
    deletionProtectionEnabled: Optional[Boolean] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.pinpointsmsvoicev2.model.Tag]] =
      Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreatePoolRequest = {
    import CreatePoolRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreatePoolRequest
      .builder()
      .originationIdentity(
        PhoneOrSenderIdOrArn.unwrap(originationIdentity): java.lang.String
      )
      .isoCountryCode(IsoCountryCode.unwrap(isoCountryCode): java.lang.String)
      .messageType(messageType.unwrap)
      .optionallyWith(
        deletionProtectionEnabled.map(value => value: java.lang.Boolean)
      )(_.deletionProtectionEnabled)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.pinpointsmsvoicev2.model.CreatePoolRequest.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.CreatePoolRequest.wrap(buildAwsValue())
}
object CreatePoolRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreatePoolRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.CreatePoolRequest =
      zio.aws.pinpointsmsvoicev2.model.CreatePoolRequest(
        originationIdentity,
        isoCountryCode,
        messageType,
        deletionProtectionEnabled.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken.map(value => value)
      )
    def originationIdentity: PhoneOrSenderIdOrArn
    def isoCountryCode: IsoCountryCode
    def messageType: zio.aws.pinpointsmsvoicev2.model.MessageType
    def deletionProtectionEnabled: Optional[Boolean]
    def tags: Optional[List[zio.aws.pinpointsmsvoicev2.model.Tag.ReadOnly]]
    def clientToken: Optional[ClientToken]
    def getOriginationIdentity: ZIO[Any, Nothing, PhoneOrSenderIdOrArn] =
      ZIO.succeed(originationIdentity)
    def getIsoCountryCode: ZIO[Any, Nothing, IsoCountryCode] =
      ZIO.succeed(isoCountryCode)
    def getMessageType
        : ZIO[Any, Nothing, zio.aws.pinpointsmsvoicev2.model.MessageType] =
      ZIO.succeed(messageType)
    def getDeletionProtectionEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("deletionProtectionEnabled", deletionProtectionEnabled)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.pinpointsmsvoicev2.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreatePoolRequest
  ) extends zio.aws.pinpointsmsvoicev2.model.CreatePoolRequest.ReadOnly {
    override val originationIdentity: PhoneOrSenderIdOrArn =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .PhoneOrSenderIdOrArn(impl.originationIdentity())
    override val isoCountryCode: IsoCountryCode =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .IsoCountryCode(impl.isoCountryCode())
    override val messageType: zio.aws.pinpointsmsvoicev2.model.MessageType =
      zio.aws.pinpointsmsvoicev2.model.MessageType.wrap(impl.messageType())
    override val deletionProtectionEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletionProtectionEnabled())
        .map(value => value: Boolean)
    override val tags
        : Optional[List[zio.aws.pinpointsmsvoicev2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpointsmsvoicev2.model.Tag.wrap(item)
          }.toList
        )
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.ClientToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreatePoolRequest
  ): zio.aws.pinpointsmsvoicev2.model.CreatePoolRequest.ReadOnly = new Wrapper(
    impl
  )
}
