package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.ConfigurationSetNameOrArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteConfigurationSetRequest(
    configurationSetName: ConfigurationSetNameOrArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteConfigurationSetRequest = {
    import DeleteConfigurationSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteConfigurationSetRequest
      .builder()
      .configurationSetName(
        ConfigurationSetNameOrArn.unwrap(configurationSetName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.DeleteConfigurationSetRequest.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.DeleteConfigurationSetRequest
      .wrap(buildAwsValue())
}
object DeleteConfigurationSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteConfigurationSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointsmsvoicev2.model.DeleteConfigurationSetRequest =
      zio.aws.pinpointsmsvoicev2.model
        .DeleteConfigurationSetRequest(configurationSetName)
    def configurationSetName: ConfigurationSetNameOrArn
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetNameOrArn] =
      ZIO.succeed(configurationSetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteConfigurationSetRequest
  ) extends zio.aws.pinpointsmsvoicev2.model.DeleteConfigurationSetRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetNameOrArn =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .ConfigurationSetNameOrArn(impl.configurationSetName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteConfigurationSetRequest
  ): zio.aws.pinpointsmsvoicev2.model.DeleteConfigurationSetRequest.ReadOnly =
    new Wrapper(impl)
}
