package zio.aws.pinpointsmsvoicev2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointsmsvoicev2.model.primitives.{
  Timestamp,
  SenderId,
  ConfigurationSetName
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DeleteConfigurationSetResponse(
    configurationSetArn: Optional[String] = Optional.Absent,
    configurationSetName: Optional[ConfigurationSetName] = Optional.Absent,
    eventDestinations: Optional[
      Iterable[zio.aws.pinpointsmsvoicev2.model.EventDestination]
    ] = Optional.Absent,
    defaultMessageType: Optional[zio.aws.pinpointsmsvoicev2.model.MessageType] =
      Optional.Absent,
    defaultSenderId: Optional[SenderId] = Optional.Absent,
    createdTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteConfigurationSetResponse = {
    import DeleteConfigurationSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteConfigurationSetResponse
      .builder()
      .optionallyWith(
        configurationSetArn.map(value => value: java.lang.String)
      )(_.configurationSetArn)
      .optionallyWith(
        configurationSetName.map(value =>
          ConfigurationSetName.unwrap(value): java.lang.String
        )
      )(_.configurationSetName)
      .optionallyWith(
        eventDestinations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.eventDestinations)
      .optionallyWith(defaultMessageType.map(value => value.unwrap))(
        _.defaultMessageType
      )
      .optionallyWith(
        defaultSenderId.map(value => SenderId.unwrap(value): java.lang.String)
      )(_.defaultSenderId)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.DeleteConfigurationSetResponse.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.DeleteConfigurationSetResponse
      .wrap(buildAwsValue())
}
object DeleteConfigurationSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteConfigurationSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointsmsvoicev2.model.DeleteConfigurationSetResponse =
      zio.aws.pinpointsmsvoicev2.model.DeleteConfigurationSetResponse(
        configurationSetArn.map(value => value),
        configurationSetName.map(value => value),
        eventDestinations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        defaultMessageType.map(value => value),
        defaultSenderId.map(value => value),
        createdTimestamp.map(value => value)
      )
    def configurationSetArn: Optional[String]
    def configurationSetName: Optional[ConfigurationSetName]
    def eventDestinations: Optional[
      List[zio.aws.pinpointsmsvoicev2.model.EventDestination.ReadOnly]
    ]
    def defaultMessageType
        : Optional[zio.aws.pinpointsmsvoicev2.model.MessageType]
    def defaultSenderId: Optional[SenderId]
    def createdTimestamp: Optional[Timestamp]
    def getConfigurationSetArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("configurationSetArn", configurationSetArn)
    def getConfigurationSetName: ZIO[Any, AwsError, ConfigurationSetName] =
      AwsError.unwrapOptionField("configurationSetName", configurationSetName)
    def getEventDestinations: ZIO[Any, AwsError, List[
      zio.aws.pinpointsmsvoicev2.model.EventDestination.ReadOnly
    ]] = AwsError.unwrapOptionField("eventDestinations", eventDestinations)
    def getDefaultMessageType
        : ZIO[Any, AwsError, zio.aws.pinpointsmsvoicev2.model.MessageType] =
      AwsError.unwrapOptionField("defaultMessageType", defaultMessageType)
    def getDefaultSenderId: ZIO[Any, AwsError, SenderId] =
      AwsError.unwrapOptionField("defaultSenderId", defaultSenderId)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteConfigurationSetResponse
  ) extends zio.aws.pinpointsmsvoicev2.model.DeleteConfigurationSetResponse.ReadOnly {
    override val configurationSetArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.configurationSetArn())
      .map(value => value: String)
    override val configurationSetName: Optional[ConfigurationSetName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationSetName())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.primitives
            .ConfigurationSetName(value)
        )
    override val eventDestinations: Optional[
      List[zio.aws.pinpointsmsvoicev2.model.EventDestination.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.eventDestinations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpointsmsvoicev2.model.EventDestination.wrap(item)
        }.toList
      )
    override val defaultMessageType
        : Optional[zio.aws.pinpointsmsvoicev2.model.MessageType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultMessageType())
        .map(value => zio.aws.pinpointsmsvoicev2.model.MessageType.wrap(value))
    override val defaultSenderId: Optional[SenderId] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultSenderId())
      .map(value => zio.aws.pinpointsmsvoicev2.model.primitives.SenderId(value))
    override val createdTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTimestamp())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.Timestamp(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteConfigurationSetResponse
  ): zio.aws.pinpointsmsvoicev2.model.DeleteConfigurationSetResponse.ReadOnly =
    new Wrapper(impl)
}
