package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.{Keyword, PhoneOrPoolIdOrArn}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteKeywordRequest(
    originationIdentity: PhoneOrPoolIdOrArn,
    keyword: Keyword
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteKeywordRequest = {
    import DeleteKeywordRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteKeywordRequest
      .builder()
      .originationIdentity(
        PhoneOrPoolIdOrArn.unwrap(originationIdentity): java.lang.String
      )
      .keyword(Keyword.unwrap(keyword): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.DeleteKeywordRequest.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.DeleteKeywordRequest.wrap(buildAwsValue())
}
object DeleteKeywordRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteKeywordRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.DeleteKeywordRequest =
      zio.aws.pinpointsmsvoicev2.model
        .DeleteKeywordRequest(originationIdentity, keyword)
    def originationIdentity: PhoneOrPoolIdOrArn
    def keyword: Keyword
    def getOriginationIdentity: ZIO[Any, Nothing, PhoneOrPoolIdOrArn] =
      ZIO.succeed(originationIdentity)
    def getKeyword: ZIO[Any, Nothing, Keyword] = ZIO.succeed(keyword)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteKeywordRequest
  ) extends zio.aws.pinpointsmsvoicev2.model.DeleteKeywordRequest.ReadOnly {
    override val originationIdentity: PhoneOrPoolIdOrArn =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .PhoneOrPoolIdOrArn(impl.originationIdentity())
    override val keyword: Keyword =
      zio.aws.pinpointsmsvoicev2.model.primitives.Keyword(impl.keyword())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteKeywordRequest
  ): zio.aws.pinpointsmsvoicev2.model.DeleteKeywordRequest.ReadOnly =
    new Wrapper(impl)
}
