package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.{KeywordMessage, Keyword}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteKeywordResponse(
    originationIdentityArn: Optional[String] = Optional.Absent,
    originationIdentity: Optional[String] = Optional.Absent,
    keyword: Optional[Keyword] = Optional.Absent,
    keywordMessage: Optional[KeywordMessage] = Optional.Absent,
    keywordAction: Optional[zio.aws.pinpointsmsvoicev2.model.KeywordAction] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteKeywordResponse = {
    import DeleteKeywordResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteKeywordResponse
      .builder()
      .optionallyWith(
        originationIdentityArn.map(value => value: java.lang.String)
      )(_.originationIdentityArn)
      .optionallyWith(
        originationIdentity.map(value => value: java.lang.String)
      )(_.originationIdentity)
      .optionallyWith(
        keyword.map(value => Keyword.unwrap(value): java.lang.String)
      )(_.keyword)
      .optionallyWith(
        keywordMessage.map(value =>
          KeywordMessage.unwrap(value): java.lang.String
        )
      )(_.keywordMessage)
      .optionallyWith(keywordAction.map(value => value.unwrap))(_.keywordAction)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.DeleteKeywordResponse.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.DeleteKeywordResponse.wrap(buildAwsValue())
}
object DeleteKeywordResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteKeywordResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.DeleteKeywordResponse =
      zio.aws.pinpointsmsvoicev2.model.DeleteKeywordResponse(
        originationIdentityArn.map(value => value),
        originationIdentity.map(value => value),
        keyword.map(value => value),
        keywordMessage.map(value => value),
        keywordAction.map(value => value)
      )
    def originationIdentityArn: Optional[String]
    def originationIdentity: Optional[String]
    def keyword: Optional[Keyword]
    def keywordMessage: Optional[KeywordMessage]
    def keywordAction: Optional[zio.aws.pinpointsmsvoicev2.model.KeywordAction]
    def getOriginationIdentityArn: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("originationIdentityArn", originationIdentityArn)
    def getOriginationIdentity: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("originationIdentity", originationIdentity)
    def getKeyword: ZIO[Any, AwsError, Keyword] =
      AwsError.unwrapOptionField("keyword", keyword)
    def getKeywordMessage: ZIO[Any, AwsError, KeywordMessage] =
      AwsError.unwrapOptionField("keywordMessage", keywordMessage)
    def getKeywordAction
        : ZIO[Any, AwsError, zio.aws.pinpointsmsvoicev2.model.KeywordAction] =
      AwsError.unwrapOptionField("keywordAction", keywordAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteKeywordResponse
  ) extends zio.aws.pinpointsmsvoicev2.model.DeleteKeywordResponse.ReadOnly {
    override val originationIdentityArn: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.originationIdentityArn())
        .map(value => value: String)
    override val originationIdentity: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.originationIdentity())
      .map(value => value: String)
    override val keyword: Optional[Keyword] = zio.aws.core.internal
      .optionalFromNullable(impl.keyword())
      .map(value => zio.aws.pinpointsmsvoicev2.model.primitives.Keyword(value))
    override val keywordMessage: Optional[KeywordMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keywordMessage())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.primitives.KeywordMessage(value)
        )
    override val keywordAction
        : Optional[zio.aws.pinpointsmsvoicev2.model.KeywordAction] =
      zio.aws.core.internal
        .optionalFromNullable(impl.keywordAction())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.KeywordAction.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteKeywordResponse
  ): zio.aws.pinpointsmsvoicev2.model.DeleteKeywordResponse.ReadOnly =
    new Wrapper(impl)
}
