package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.OptOutListNameOrArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteOptOutListRequest(optOutListName: OptOutListNameOrArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteOptOutListRequest = {
    import DeleteOptOutListRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteOptOutListRequest
      .builder()
      .optOutListName(
        OptOutListNameOrArn.unwrap(optOutListName): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.DeleteOptOutListRequest.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.DeleteOptOutListRequest
      .wrap(buildAwsValue())
}
object DeleteOptOutListRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteOptOutListRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.DeleteOptOutListRequest =
      zio.aws.pinpointsmsvoicev2.model.DeleteOptOutListRequest(optOutListName)
    def optOutListName: OptOutListNameOrArn
    def getOptOutListName: ZIO[Any, Nothing, OptOutListNameOrArn] =
      ZIO.succeed(optOutListName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteOptOutListRequest
  ) extends zio.aws.pinpointsmsvoicev2.model.DeleteOptOutListRequest.ReadOnly {
    override val optOutListName: OptOutListNameOrArn =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .OptOutListNameOrArn(impl.optOutListName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteOptOutListRequest
  ): zio.aws.pinpointsmsvoicev2.model.DeleteOptOutListRequest.ReadOnly =
    new Wrapper(impl)
}
