package zio.aws.pinpointsmsvoicev2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointsmsvoicev2.model.primitives.{Timestamp, OptOutListName}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DeleteOptOutListResponse(
    optOutListArn: Optional[String] = Optional.Absent,
    optOutListName: Optional[OptOutListName] = Optional.Absent,
    createdTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteOptOutListResponse = {
    import DeleteOptOutListResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteOptOutListResponse
      .builder()
      .optionallyWith(optOutListArn.map(value => value: java.lang.String))(
        _.optOutListArn
      )
      .optionallyWith(
        optOutListName.map(value =>
          OptOutListName.unwrap(value): java.lang.String
        )
      )(_.optOutListName)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.DeleteOptOutListResponse.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.DeleteOptOutListResponse
      .wrap(buildAwsValue())
}
object DeleteOptOutListResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteOptOutListResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.DeleteOptOutListResponse =
      zio.aws.pinpointsmsvoicev2.model.DeleteOptOutListResponse(
        optOutListArn.map(value => value),
        optOutListName.map(value => value),
        createdTimestamp.map(value => value)
      )
    def optOutListArn: Optional[String]
    def optOutListName: Optional[OptOutListName]
    def createdTimestamp: Optional[Timestamp]
    def getOptOutListArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optOutListArn", optOutListArn)
    def getOptOutListName: ZIO[Any, AwsError, OptOutListName] =
      AwsError.unwrapOptionField("optOutListName", optOutListName)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteOptOutListResponse
  ) extends zio.aws.pinpointsmsvoicev2.model.DeleteOptOutListResponse.ReadOnly {
    override val optOutListArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.optOutListArn())
      .map(value => value: String)
    override val optOutListName: Optional[OptOutListName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optOutListName())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.primitives.OptOutListName(value)
        )
    override val createdTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTimestamp())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.Timestamp(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteOptOutListResponse
  ): zio.aws.pinpointsmsvoicev2.model.DeleteOptOutListResponse.ReadOnly =
    new Wrapper(impl)
}
