package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.{
  PhoneNumber,
  OptOutListNameOrArn
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteOptedOutNumberRequest(
    optOutListName: OptOutListNameOrArn,
    optedOutNumber: PhoneNumber
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteOptedOutNumberRequest = {
    import DeleteOptedOutNumberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteOptedOutNumberRequest
      .builder()
      .optOutListName(
        OptOutListNameOrArn.unwrap(optOutListName): java.lang.String
      )
      .optedOutNumber(PhoneNumber.unwrap(optedOutNumber): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.DeleteOptedOutNumberRequest.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.DeleteOptedOutNumberRequest
      .wrap(buildAwsValue())
}
object DeleteOptedOutNumberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteOptedOutNumberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointsmsvoicev2.model.DeleteOptedOutNumberRequest =
      zio.aws.pinpointsmsvoicev2.model
        .DeleteOptedOutNumberRequest(optOutListName, optedOutNumber)
    def optOutListName: OptOutListNameOrArn
    def optedOutNumber: PhoneNumber
    def getOptOutListName: ZIO[Any, Nothing, OptOutListNameOrArn] =
      ZIO.succeed(optOutListName)
    def getOptedOutNumber: ZIO[Any, Nothing, PhoneNumber] =
      ZIO.succeed(optedOutNumber)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteOptedOutNumberRequest
  ) extends zio.aws.pinpointsmsvoicev2.model.DeleteOptedOutNumberRequest.ReadOnly {
    override val optOutListName: OptOutListNameOrArn =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .OptOutListNameOrArn(impl.optOutListName())
    override val optedOutNumber: PhoneNumber =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .PhoneNumber(impl.optedOutNumber())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteOptedOutNumberRequest
  ): zio.aws.pinpointsmsvoicev2.model.DeleteOptedOutNumberRequest.ReadOnly =
    new Wrapper(impl)
}
