package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.MonthlyLimit
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteTextMessageSpendLimitOverrideResponse(
    monthlyLimit: Optional[MonthlyLimit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteTextMessageSpendLimitOverrideResponse = {
    import DeleteTextMessageSpendLimitOverrideResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteTextMessageSpendLimitOverrideResponse
      .builder()
      .optionallyWith(
        monthlyLimit.map(value => MonthlyLimit.unwrap(value): java.lang.Long)
      )(_.monthlyLimit)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.DeleteTextMessageSpendLimitOverrideResponse.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.DeleteTextMessageSpendLimitOverrideResponse
      .wrap(buildAwsValue())
}
object DeleteTextMessageSpendLimitOverrideResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteTextMessageSpendLimitOverrideResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointsmsvoicev2.model.DeleteTextMessageSpendLimitOverrideResponse =
      zio.aws.pinpointsmsvoicev2.model
        .DeleteTextMessageSpendLimitOverrideResponse(
          monthlyLimit.map(value => value)
        )
    def monthlyLimit: Optional[MonthlyLimit]
    def getMonthlyLimit: ZIO[Any, AwsError, MonthlyLimit] =
      AwsError.unwrapOptionField("monthlyLimit", monthlyLimit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteTextMessageSpendLimitOverrideResponse
  ) extends zio.aws.pinpointsmsvoicev2.model.DeleteTextMessageSpendLimitOverrideResponse.ReadOnly {
    override val monthlyLimit: Optional[MonthlyLimit] = zio.aws.core.internal
      .optionalFromNullable(impl.monthlyLimit())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.MonthlyLimit(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DeleteTextMessageSpendLimitOverrideResponse
  ): zio.aws.pinpointsmsvoicev2.model.DeleteTextMessageSpendLimitOverrideResponse.ReadOnly =
    new Wrapper(impl)
}
