package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeConfigurationSetsResponse(
    configurationSets: Optional[
      Iterable[zio.aws.pinpointsmsvoicev2.model.ConfigurationSetInformation]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsResponse = {
    import DescribeConfigurationSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsResponse
      .builder()
      .optionallyWith(
        configurationSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.configurationSets)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.DescribeConfigurationSetsResponse.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.DescribeConfigurationSetsResponse
      .wrap(buildAwsValue())
}
object DescribeConfigurationSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointsmsvoicev2.model.DescribeConfigurationSetsResponse =
      zio.aws.pinpointsmsvoicev2.model.DescribeConfigurationSetsResponse(
        configurationSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def configurationSets: Optional[List[
      zio.aws.pinpointsmsvoicev2.model.ConfigurationSetInformation.ReadOnly
    ]]
    def nextToken: Optional[NextToken]
    def getConfigurationSets: ZIO[Any, AwsError, List[
      zio.aws.pinpointsmsvoicev2.model.ConfigurationSetInformation.ReadOnly
    ]] = AwsError.unwrapOptionField("configurationSets", configurationSets)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsResponse
  ) extends zio.aws.pinpointsmsvoicev2.model.DescribeConfigurationSetsResponse.ReadOnly {
    override val configurationSets: Optional[List[
      zio.aws.pinpointsmsvoicev2.model.ConfigurationSetInformation.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.configurationSets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpointsmsvoicev2.model.ConfigurationSetInformation
            .wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeConfigurationSetsResponse
  ): zio.aws.pinpointsmsvoicev2.model.DescribeConfigurationSetsResponse.ReadOnly =
    new Wrapper(impl)
}
