package zio.aws.pinpointsmsvoicev2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointsmsvoicev2.model.primitives.{
  MaxResults,
  NextToken,
  PhoneNumber,
  OptOutListNameOrArn
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeOptedOutNumbersRequest(
    optOutListName: OptOutListNameOrArn,
    optedOutNumbers: Optional[Iterable[PhoneNumber]] = Optional.Absent,
    filters: Optional[
      Iterable[zio.aws.pinpointsmsvoicev2.model.OptedOutFilter]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest = {
    import DescribeOptedOutNumbersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest
      .builder()
      .optOutListName(
        OptOutListNameOrArn.unwrap(optOutListName): java.lang.String
      )
      .optionallyWith(
        optedOutNumbers.map(value =>
          value.map { item =>
            PhoneNumber.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.optedOutNumbers)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest
      .wrap(buildAwsValue())
}
object DescribeOptedOutNumbersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest =
      zio.aws.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest(
        optOutListName,
        optedOutNumbers.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def optOutListName: OptOutListNameOrArn
    def optedOutNumbers: Optional[List[PhoneNumber]]
    def filters: Optional[
      List[zio.aws.pinpointsmsvoicev2.model.OptedOutFilter.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getOptOutListName: ZIO[Any, Nothing, OptOutListNameOrArn] =
      ZIO.succeed(optOutListName)
    def getOptedOutNumbers: ZIO[Any, AwsError, List[PhoneNumber]] =
      AwsError.unwrapOptionField("optedOutNumbers", optedOutNumbers)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.pinpointsmsvoicev2.model.OptedOutFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest
  ) extends zio.aws.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest.ReadOnly {
    override val optOutListName: OptOutListNameOrArn =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .OptOutListNameOrArn(impl.optOutListName())
    override val optedOutNumbers: Optional[List[PhoneNumber]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optedOutNumbers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpointsmsvoicev2.model.primitives.PhoneNumber(item)
          }.toList
        )
    override val filters: Optional[
      List[zio.aws.pinpointsmsvoicev2.model.OptedOutFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpointsmsvoicev2.model.OptedOutFilter.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.NextToken(value)
      )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.MaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest
  ): zio.aws.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest.ReadOnly =
    new Wrapper(impl)
}
