package zio.aws.pinpointsmsvoicev2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointsmsvoicev2.model.primitives.{
  MaxResults,
  NextToken,
  PhoneNumberIdOrArn
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribePhoneNumbersRequest(
    phoneNumberIds: Optional[Iterable[PhoneNumberIdOrArn]] = Optional.Absent,
    filters: Optional[
      Iterable[zio.aws.pinpointsmsvoicev2.model.PhoneNumberFilter]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest = {
    import DescribePhoneNumbersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest
      .builder()
      .optionallyWith(
        phoneNumberIds.map(value =>
          value.map { item =>
            PhoneNumberIdOrArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.phoneNumberIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest
      .wrap(buildAwsValue())
}
object DescribePhoneNumbersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest =
      zio.aws.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest(
        phoneNumberIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def phoneNumberIds: Optional[List[PhoneNumberIdOrArn]]
    def filters: Optional[
      List[zio.aws.pinpointsmsvoicev2.model.PhoneNumberFilter.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getPhoneNumberIds: ZIO[Any, AwsError, List[PhoneNumberIdOrArn]] =
      AwsError.unwrapOptionField("phoneNumberIds", phoneNumberIds)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.pinpointsmsvoicev2.model.PhoneNumberFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest
  ) extends zio.aws.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest.ReadOnly {
    override val phoneNumberIds: Optional[List[PhoneNumberIdOrArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.phoneNumberIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpointsmsvoicev2.model.primitives.PhoneNumberIdOrArn(item)
          }.toList
        )
    override val filters: Optional[
      List[zio.aws.pinpointsmsvoicev2.model.PhoneNumberFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpointsmsvoicev2.model.PhoneNumberFilter.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.NextToken(value)
      )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.MaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest
  ): zio.aws.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest.ReadOnly =
    new Wrapper(impl)
}
