package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribePhoneNumbersResponse(
    phoneNumbers: Optional[
      Iterable[zio.aws.pinpointsmsvoicev2.model.PhoneNumberInformation]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersResponse = {
    import DescribePhoneNumbersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersResponse
      .builder()
      .optionallyWith(
        phoneNumbers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.phoneNumbers)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.DescribePhoneNumbersResponse.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.DescribePhoneNumbersResponse
      .wrap(buildAwsValue())
}
object DescribePhoneNumbersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointsmsvoicev2.model.DescribePhoneNumbersResponse =
      zio.aws.pinpointsmsvoicev2.model.DescribePhoneNumbersResponse(
        phoneNumbers.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def phoneNumbers: Optional[
      List[zio.aws.pinpointsmsvoicev2.model.PhoneNumberInformation.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getPhoneNumbers: ZIO[Any, AwsError, List[
      zio.aws.pinpointsmsvoicev2.model.PhoneNumberInformation.ReadOnly
    ]] = AwsError.unwrapOptionField("phoneNumbers", phoneNumbers)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersResponse
  ) extends zio.aws.pinpointsmsvoicev2.model.DescribePhoneNumbersResponse.ReadOnly {
    override val phoneNumbers: Optional[
      List[zio.aws.pinpointsmsvoicev2.model.PhoneNumberInformation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.phoneNumbers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpointsmsvoicev2.model.PhoneNumberInformation.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePhoneNumbersResponse
  ): zio.aws.pinpointsmsvoicev2.model.DescribePhoneNumbersResponse.ReadOnly =
    new Wrapper(impl)
}
