package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribePoolsResponse(
    pools: Optional[
      Iterable[zio.aws.pinpointsmsvoicev2.model.PoolInformation]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsResponse = {
    import DescribePoolsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsResponse
      .builder()
      .optionallyWith(
        pools.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.pools)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.DescribePoolsResponse.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.DescribePoolsResponse.wrap(buildAwsValue())
}
object DescribePoolsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.DescribePoolsResponse =
      zio.aws.pinpointsmsvoicev2.model.DescribePoolsResponse(
        pools.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def pools: Optional[
      List[zio.aws.pinpointsmsvoicev2.model.PoolInformation.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def getPools: ZIO[Any, AwsError, List[
      zio.aws.pinpointsmsvoicev2.model.PoolInformation.ReadOnly
    ]] = AwsError.unwrapOptionField("pools", pools)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsResponse
  ) extends zio.aws.pinpointsmsvoicev2.model.DescribePoolsResponse.ReadOnly {
    override val pools: Optional[
      List[zio.aws.pinpointsmsvoicev2.model.PoolInformation.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.pools())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpointsmsvoicev2.model.PoolInformation.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribePoolsResponse
  ): zio.aws.pinpointsmsvoicev2.model.DescribePoolsResponse.ReadOnly =
    new Wrapper(impl)
}
