package zio.aws.pinpointsmsvoicev2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointsmsvoicev2.model.primitives.{MaxResults, NextToken}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeSenderIdsRequest(
    senderIds: Optional[
      Iterable[zio.aws.pinpointsmsvoicev2.model.SenderIdAndCountry]
    ] = Optional.Absent,
    filters: Optional[
      Iterable[zio.aws.pinpointsmsvoicev2.model.SenderIdFilter]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsRequest = {
    import DescribeSenderIdsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsRequest
      .builder()
      .optionallyWith(
        senderIds.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.senderIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.DescribeSenderIdsRequest.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.DescribeSenderIdsRequest
      .wrap(buildAwsValue())
}
object DescribeSenderIdsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.DescribeSenderIdsRequest =
      zio.aws.pinpointsmsvoicev2.model.DescribeSenderIdsRequest(
        senderIds.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def senderIds: Optional[
      List[zio.aws.pinpointsmsvoicev2.model.SenderIdAndCountry.ReadOnly]
    ]
    def filters: Optional[
      List[zio.aws.pinpointsmsvoicev2.model.SenderIdFilter.ReadOnly]
    ]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getSenderIds: ZIO[Any, AwsError, List[
      zio.aws.pinpointsmsvoicev2.model.SenderIdAndCountry.ReadOnly
    ]] = AwsError.unwrapOptionField("senderIds", senderIds)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.pinpointsmsvoicev2.model.SenderIdFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsRequest
  ) extends zio.aws.pinpointsmsvoicev2.model.DescribeSenderIdsRequest.ReadOnly {
    override val senderIds: Optional[
      List[zio.aws.pinpointsmsvoicev2.model.SenderIdAndCountry.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.senderIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpointsmsvoicev2.model.SenderIdAndCountry.wrap(item)
        }.toList
      )
    override val filters: Optional[
      List[zio.aws.pinpointsmsvoicev2.model.SenderIdFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpointsmsvoicev2.model.SenderIdFilter.wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.NextToken(value)
      )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.MaxResults(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.DescribeSenderIdsRequest
  ): zio.aws.pinpointsmsvoicev2.model.DescribeSenderIdsRequest.ReadOnly =
    new Wrapper(impl)
}
