package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.EventDestinationName
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EventDestination(
    eventDestinationName: EventDestinationName,
    enabled: Boolean,
    matchingEventTypes: Iterable[zio.aws.pinpointsmsvoicev2.model.EventType],
    cloudWatchLogsDestination: Optional[
      zio.aws.pinpointsmsvoicev2.model.CloudWatchLogsDestination
    ] = Optional.Absent,
    kinesisFirehoseDestination: Optional[
      zio.aws.pinpointsmsvoicev2.model.KinesisFirehoseDestination
    ] = Optional.Absent,
    snsDestination: Optional[zio.aws.pinpointsmsvoicev2.model.SnsDestination] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.EventDestination = {
    import EventDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.EventDestination
      .builder()
      .eventDestinationName(
        EventDestinationName.unwrap(eventDestinationName): java.lang.String
      )
      .enabled(enabled: java.lang.Boolean)
      .matchingEventTypesWithStrings(matchingEventTypes.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .optionallyWith(
        cloudWatchLogsDestination.map(value => value.buildAwsValue())
      )(_.cloudWatchLogsDestination)
      .optionallyWith(
        kinesisFirehoseDestination.map(value => value.buildAwsValue())
      )(_.kinesisFirehoseDestination)
      .optionallyWith(snsDestination.map(value => value.buildAwsValue()))(
        _.snsDestination
      )
      .build()
  }
  def asReadOnly: zio.aws.pinpointsmsvoicev2.model.EventDestination.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.EventDestination.wrap(buildAwsValue())
}
object EventDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.EventDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.EventDestination =
      zio.aws.pinpointsmsvoicev2.model.EventDestination(
        eventDestinationName,
        enabled,
        matchingEventTypes,
        cloudWatchLogsDestination.map(value => value.asEditable),
        kinesisFirehoseDestination.map(value => value.asEditable),
        snsDestination.map(value => value.asEditable)
      )
    def eventDestinationName: EventDestinationName
    def enabled: Boolean
    def matchingEventTypes: List[zio.aws.pinpointsmsvoicev2.model.EventType]
    def cloudWatchLogsDestination: Optional[
      zio.aws.pinpointsmsvoicev2.model.CloudWatchLogsDestination.ReadOnly
    ]
    def kinesisFirehoseDestination: Optional[
      zio.aws.pinpointsmsvoicev2.model.KinesisFirehoseDestination.ReadOnly
    ]
    def snsDestination
        : Optional[zio.aws.pinpointsmsvoicev2.model.SnsDestination.ReadOnly]
    def getEventDestinationName: ZIO[Any, Nothing, EventDestinationName] =
      ZIO.succeed(eventDestinationName)
    def getEnabled: ZIO[Any, Nothing, Boolean] = ZIO.succeed(enabled)
    def getMatchingEventTypes
        : ZIO[Any, Nothing, List[zio.aws.pinpointsmsvoicev2.model.EventType]] =
      ZIO.succeed(matchingEventTypes)
    def getCloudWatchLogsDestination: ZIO[
      Any,
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.CloudWatchLogsDestination.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchLogsDestination",
      cloudWatchLogsDestination
    )
    def getKinesisFirehoseDestination: ZIO[
      Any,
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.KinesisFirehoseDestination.ReadOnly
    ] = AwsError.unwrapOptionField(
      "kinesisFirehoseDestination",
      kinesisFirehoseDestination
    )
    def getSnsDestination: ZIO[
      Any,
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.SnsDestination.ReadOnly
    ] = AwsError.unwrapOptionField("snsDestination", snsDestination)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.EventDestination
  ) extends zio.aws.pinpointsmsvoicev2.model.EventDestination.ReadOnly {
    override val eventDestinationName: EventDestinationName =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .EventDestinationName(impl.eventDestinationName())
    override val enabled: Boolean = impl.enabled(): Boolean
    override val matchingEventTypes
        : List[zio.aws.pinpointsmsvoicev2.model.EventType] = impl
      .matchingEventTypes()
      .asScala
      .map { item =>
        zio.aws.pinpointsmsvoicev2.model.EventType.wrap(item)
      }
      .toList
    override val cloudWatchLogsDestination: Optional[
      zio.aws.pinpointsmsvoicev2.model.CloudWatchLogsDestination.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.cloudWatchLogsDestination())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.CloudWatchLogsDestination.wrap(value)
      )
    override val kinesisFirehoseDestination: Optional[
      zio.aws.pinpointsmsvoicev2.model.KinesisFirehoseDestination.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.kinesisFirehoseDestination())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.KinesisFirehoseDestination.wrap(value)
      )
    override val snsDestination
        : Optional[zio.aws.pinpointsmsvoicev2.model.SnsDestination.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.snsDestination())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.SnsDestination.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.EventDestination
  ): zio.aws.pinpointsmsvoicev2.model.EventDestination.ReadOnly = new Wrapper(
    impl
  )
}
