package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.FilterValue
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class KeywordFilter(
    name: zio.aws.pinpointsmsvoicev2.model.KeywordFilterName,
    values: Iterable[FilterValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.KeywordFilter = {
    import KeywordFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.KeywordFilter
      .builder()
      .name(name.unwrap)
      .values(values.map { item =>
        FilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.pinpointsmsvoicev2.model.KeywordFilter.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.KeywordFilter.wrap(buildAwsValue())
}
object KeywordFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.KeywordFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.KeywordFilter =
      zio.aws.pinpointsmsvoicev2.model.KeywordFilter(name, values)
    def name: zio.aws.pinpointsmsvoicev2.model.KeywordFilterName
    def values: List[FilterValue]
    def getName: ZIO[
      Any,
      Nothing,
      zio.aws.pinpointsmsvoicev2.model.KeywordFilterName
    ] = ZIO.succeed(name)
    def getValues: ZIO[Any, Nothing, List[FilterValue]] = ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.KeywordFilter
  ) extends zio.aws.pinpointsmsvoicev2.model.KeywordFilter.ReadOnly {
    override val name: zio.aws.pinpointsmsvoicev2.model.KeywordFilterName =
      zio.aws.pinpointsmsvoicev2.model.KeywordFilterName.wrap(impl.name())
    override val values: List[FilterValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.pinpointsmsvoicev2.model.primitives.FilterValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.KeywordFilter
  ): zio.aws.pinpointsmsvoicev2.model.KeywordFilter.ReadOnly = new Wrapper(impl)
}
