package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.{KeywordMessage, Keyword}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class KeywordInformation(
    keyword: Keyword,
    keywordMessage: KeywordMessage,
    keywordAction: zio.aws.pinpointsmsvoicev2.model.KeywordAction
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.KeywordInformation = {
    import KeywordInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.KeywordInformation
      .builder()
      .keyword(Keyword.unwrap(keyword): java.lang.String)
      .keywordMessage(KeywordMessage.unwrap(keywordMessage): java.lang.String)
      .keywordAction(keywordAction.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.pinpointsmsvoicev2.model.KeywordInformation.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.KeywordInformation.wrap(buildAwsValue())
}
object KeywordInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.KeywordInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.KeywordInformation =
      zio.aws.pinpointsmsvoicev2.model
        .KeywordInformation(keyword, keywordMessage, keywordAction)
    def keyword: Keyword
    def keywordMessage: KeywordMessage
    def keywordAction: zio.aws.pinpointsmsvoicev2.model.KeywordAction
    def getKeyword: ZIO[Any, Nothing, Keyword] = ZIO.succeed(keyword)
    def getKeywordMessage: ZIO[Any, Nothing, KeywordMessage] =
      ZIO.succeed(keywordMessage)
    def getKeywordAction
        : ZIO[Any, Nothing, zio.aws.pinpointsmsvoicev2.model.KeywordAction] =
      ZIO.succeed(keywordAction)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.KeywordInformation
  ) extends zio.aws.pinpointsmsvoicev2.model.KeywordInformation.ReadOnly {
    override val keyword: Keyword =
      zio.aws.pinpointsmsvoicev2.model.primitives.Keyword(impl.keyword())
    override val keywordMessage: KeywordMessage =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .KeywordMessage(impl.keywordMessage())
    override val keywordAction: zio.aws.pinpointsmsvoicev2.model.KeywordAction =
      zio.aws.pinpointsmsvoicev2.model.KeywordAction.wrap(impl.keywordAction())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.KeywordInformation
  ): zio.aws.pinpointsmsvoicev2.model.KeywordInformation.ReadOnly = new Wrapper(
    impl
  )
}
