package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.{
  DeliveryStreamArn,
  IamRoleArn
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class KinesisFirehoseDestination(
    iamRoleArn: IamRoleArn,
    deliveryStreamArn: DeliveryStreamArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.KinesisFirehoseDestination = {
    import KinesisFirehoseDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.KinesisFirehoseDestination
      .builder()
      .iamRoleArn(IamRoleArn.unwrap(iamRoleArn): java.lang.String)
      .deliveryStreamArn(
        DeliveryStreamArn.unwrap(deliveryStreamArn): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.KinesisFirehoseDestination.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.KinesisFirehoseDestination
      .wrap(buildAwsValue())
}
object KinesisFirehoseDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.KinesisFirehoseDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointsmsvoicev2.model.KinesisFirehoseDestination =
      zio.aws.pinpointsmsvoicev2.model
        .KinesisFirehoseDestination(iamRoleArn, deliveryStreamArn)
    def iamRoleArn: IamRoleArn
    def deliveryStreamArn: DeliveryStreamArn
    def getIamRoleArn: ZIO[Any, Nothing, IamRoleArn] = ZIO.succeed(iamRoleArn)
    def getDeliveryStreamArn: ZIO[Any, Nothing, DeliveryStreamArn] =
      ZIO.succeed(deliveryStreamArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.KinesisFirehoseDestination
  ) extends zio.aws.pinpointsmsvoicev2.model.KinesisFirehoseDestination.ReadOnly {
    override val iamRoleArn: IamRoleArn =
      zio.aws.pinpointsmsvoicev2.model.primitives.IamRoleArn(impl.iamRoleArn())
    override val deliveryStreamArn: DeliveryStreamArn =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .DeliveryStreamArn(impl.deliveryStreamArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.KinesisFirehoseDestination
  ): zio.aws.pinpointsmsvoicev2.model.KinesisFirehoseDestination.ReadOnly =
    new Wrapper(impl)
}
