package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListPoolOriginationIdentitiesResponse(
    poolArn: Optional[String] = Optional.Absent,
    poolId: Optional[String] = Optional.Absent,
    originationIdentities: Optional[
      Iterable[zio.aws.pinpointsmsvoicev2.model.OriginationIdentityMetadata]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse = {
    import ListPoolOriginationIdentitiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse
      .builder()
      .optionallyWith(poolArn.map(value => value: java.lang.String))(_.poolArn)
      .optionallyWith(poolId.map(value => value: java.lang.String))(_.poolId)
      .optionallyWith(
        originationIdentities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.originationIdentities)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse
      .wrap(buildAwsValue())
}
object ListPoolOriginationIdentitiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse =
      zio.aws.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse(
        poolArn.map(value => value),
        poolId.map(value => value),
        originationIdentities.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def poolArn: Optional[String]
    def poolId: Optional[String]
    def originationIdentities: Optional[List[
      zio.aws.pinpointsmsvoicev2.model.OriginationIdentityMetadata.ReadOnly
    ]]
    def nextToken: Optional[NextToken]
    def getPoolArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("poolArn", poolArn)
    def getPoolId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("poolId", poolId)
    def getOriginationIdentities: ZIO[Any, AwsError, List[
      zio.aws.pinpointsmsvoicev2.model.OriginationIdentityMetadata.ReadOnly
    ]] =
      AwsError.unwrapOptionField("originationIdentities", originationIdentities)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse
  ) extends zio.aws.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse.ReadOnly {
    override val poolArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.poolArn())
      .map(value => value: String)
    override val poolId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.poolId())
      .map(value => value: String)
    override val originationIdentities: Optional[List[
      zio.aws.pinpointsmsvoicev2.model.OriginationIdentityMetadata.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.originationIdentities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.pinpointsmsvoicev2.model.OriginationIdentityMetadata
            .wrap(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.NextToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse
  ): zio.aws.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse.ReadOnly =
    new Wrapper(impl)
}
