package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.AmazonResourceName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(resourceArn: AmazonResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(AmazonResourceName.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.ListTagsForResourceRequest
      .wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointsmsvoicev2.model.ListTagsForResourceRequest =
      zio.aws.pinpointsmsvoicev2.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: AmazonResourceName
    def getResourceArn: ZIO[Any, Nothing, AmazonResourceName] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListTagsForResourceRequest
  ) extends zio.aws.pinpointsmsvoicev2.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: AmazonResourceName =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .AmazonResourceName(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.ListTagsForResourceRequest
  ): zio.aws.pinpointsmsvoicev2.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
