package zio.aws.pinpointsmsvoicev2.model
import scala.jdk.CollectionConverters.*
sealed trait MessageType {
  def unwrap
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.MessageType
}
object MessageType {
  def wrap(
      value: software.amazon.awssdk.services.pinpointsmsvoicev2.model.MessageType
  ): zio.aws.pinpointsmsvoicev2.model.MessageType = value match {
    case software.amazon.awssdk.services.pinpointsmsvoicev2.model.MessageType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.pinpointsmsvoicev2.model.MessageType.TRANSACTIONAL =>
      val r = TRANSACTIONAL
      r
    case software.amazon.awssdk.services.pinpointsmsvoicev2.model.MessageType.PROMOTIONAL =>
      val r = PROMOTIONAL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.pinpointsmsvoicev2.model.MessageType {
    override def unwrap
        : software.amazon.awssdk.services.pinpointsmsvoicev2.model.MessageType =
      software.amazon.awssdk.services.pinpointsmsvoicev2.model.MessageType.UNKNOWN_TO_SDK_VERSION
  }
  case object TRANSACTIONAL
      extends zio.aws.pinpointsmsvoicev2.model.MessageType {
    override def unwrap
        : software.amazon.awssdk.services.pinpointsmsvoicev2.model.MessageType =
      software.amazon.awssdk.services.pinpointsmsvoicev2.model.MessageType.TRANSACTIONAL
  }
  case object PROMOTIONAL extends zio.aws.pinpointsmsvoicev2.model.MessageType {
    override def unwrap
        : software.amazon.awssdk.services.pinpointsmsvoicev2.model.MessageType =
      software.amazon.awssdk.services.pinpointsmsvoicev2.model.MessageType.PROMOTIONAL
  }
}
