package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.{
  PrimitiveBoolean,
  Timestamp,
  PhoneNumber
}
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class OptedOutNumberInformation(
    optedOutNumber: PhoneNumber,
    optedOutTimestamp: Timestamp,
    endUserOptedOut: PrimitiveBoolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.OptedOutNumberInformation = {
    import OptedOutNumberInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.OptedOutNumberInformation
      .builder()
      .optedOutNumber(PhoneNumber.unwrap(optedOutNumber): java.lang.String)
      .optedOutTimestamp(Timestamp.unwrap(optedOutTimestamp): Instant)
      .endUserOptedOut(
        PrimitiveBoolean.unwrap(endUserOptedOut): java.lang.Boolean
      )
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.OptedOutNumberInformation.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.OptedOutNumberInformation
      .wrap(buildAwsValue())
}
object OptedOutNumberInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.OptedOutNumberInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.OptedOutNumberInformation =
      zio.aws.pinpointsmsvoicev2.model.OptedOutNumberInformation(
        optedOutNumber,
        optedOutTimestamp,
        endUserOptedOut
      )
    def optedOutNumber: PhoneNumber
    def optedOutTimestamp: Timestamp
    def endUserOptedOut: PrimitiveBoolean
    def getOptedOutNumber: ZIO[Any, Nothing, PhoneNumber] =
      ZIO.succeed(optedOutNumber)
    def getOptedOutTimestamp: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(optedOutTimestamp)
    def getEndUserOptedOut: ZIO[Any, Nothing, PrimitiveBoolean] =
      ZIO.succeed(endUserOptedOut)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.OptedOutNumberInformation
  ) extends zio.aws.pinpointsmsvoicev2.model.OptedOutNumberInformation.ReadOnly {
    override val optedOutNumber: PhoneNumber =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .PhoneNumber(impl.optedOutNumber())
    override val optedOutTimestamp: Timestamp =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .Timestamp(impl.optedOutTimestamp())
    override val endUserOptedOut: PrimitiveBoolean =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .PrimitiveBoolean(impl.endUserOptedOut())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.OptedOutNumberInformation
  ): zio.aws.pinpointsmsvoicev2.model.OptedOutNumberInformation.ReadOnly =
    new Wrapper(impl)
}
