package zio.aws.pinpointsmsvoicev2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointsmsvoicev2.model.primitives.{
  Timestamp,
  OptOutListName,
  TwoWayChannelArn,
  PrimitiveBoolean
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class PoolInformation(
    poolArn: String,
    poolId: String,
    status: zio.aws.pinpointsmsvoicev2.model.PoolStatus,
    messageType: zio.aws.pinpointsmsvoicev2.model.MessageType,
    twoWayEnabled: PrimitiveBoolean,
    twoWayChannelArn: Optional[TwoWayChannelArn] = Optional.Absent,
    selfManagedOptOutsEnabled: PrimitiveBoolean,
    optOutListName: OptOutListName,
    sharedRoutesEnabled: PrimitiveBoolean,
    deletionProtectionEnabled: PrimitiveBoolean,
    createdTimestamp: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.PoolInformation = {
    import PoolInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.PoolInformation
      .builder()
      .poolArn(poolArn: java.lang.String)
      .poolId(poolId: java.lang.String)
      .status(status.unwrap)
      .messageType(messageType.unwrap)
      .twoWayEnabled(PrimitiveBoolean.unwrap(twoWayEnabled): java.lang.Boolean)
      .optionallyWith(
        twoWayChannelArn.map(value =>
          TwoWayChannelArn.unwrap(value): java.lang.String
        )
      )(_.twoWayChannelArn)
      .selfManagedOptOutsEnabled(
        PrimitiveBoolean.unwrap(selfManagedOptOutsEnabled): java.lang.Boolean
      )
      .optOutListName(OptOutListName.unwrap(optOutListName): java.lang.String)
      .sharedRoutesEnabled(
        PrimitiveBoolean.unwrap(sharedRoutesEnabled): java.lang.Boolean
      )
      .deletionProtectionEnabled(
        PrimitiveBoolean.unwrap(deletionProtectionEnabled): java.lang.Boolean
      )
      .createdTimestamp(Timestamp.unwrap(createdTimestamp): Instant)
      .build()
  }
  def asReadOnly: zio.aws.pinpointsmsvoicev2.model.PoolInformation.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.PoolInformation.wrap(buildAwsValue())
}
object PoolInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.PoolInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.PoolInformation =
      zio.aws.pinpointsmsvoicev2.model.PoolInformation(
        poolArn,
        poolId,
        status,
        messageType,
        twoWayEnabled,
        twoWayChannelArn.map(value => value),
        selfManagedOptOutsEnabled,
        optOutListName,
        sharedRoutesEnabled,
        deletionProtectionEnabled,
        createdTimestamp
      )
    def poolArn: String
    def poolId: String
    def status: zio.aws.pinpointsmsvoicev2.model.PoolStatus
    def messageType: zio.aws.pinpointsmsvoicev2.model.MessageType
    def twoWayEnabled: PrimitiveBoolean
    def twoWayChannelArn: Optional[TwoWayChannelArn]
    def selfManagedOptOutsEnabled: PrimitiveBoolean
    def optOutListName: OptOutListName
    def sharedRoutesEnabled: PrimitiveBoolean
    def deletionProtectionEnabled: PrimitiveBoolean
    def createdTimestamp: Timestamp
    def getPoolArn: ZIO[Any, Nothing, String] = ZIO.succeed(poolArn)
    def getPoolId: ZIO[Any, Nothing, String] = ZIO.succeed(poolId)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.pinpointsmsvoicev2.model.PoolStatus] =
      ZIO.succeed(status)
    def getMessageType
        : ZIO[Any, Nothing, zio.aws.pinpointsmsvoicev2.model.MessageType] =
      ZIO.succeed(messageType)
    def getTwoWayEnabled: ZIO[Any, Nothing, PrimitiveBoolean] =
      ZIO.succeed(twoWayEnabled)
    def getTwoWayChannelArn: ZIO[Any, AwsError, TwoWayChannelArn] =
      AwsError.unwrapOptionField("twoWayChannelArn", twoWayChannelArn)
    def getSelfManagedOptOutsEnabled: ZIO[Any, Nothing, PrimitiveBoolean] =
      ZIO.succeed(selfManagedOptOutsEnabled)
    def getOptOutListName: ZIO[Any, Nothing, OptOutListName] =
      ZIO.succeed(optOutListName)
    def getSharedRoutesEnabled: ZIO[Any, Nothing, PrimitiveBoolean] =
      ZIO.succeed(sharedRoutesEnabled)
    def getDeletionProtectionEnabled: ZIO[Any, Nothing, PrimitiveBoolean] =
      ZIO.succeed(deletionProtectionEnabled)
    def getCreatedTimestamp: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(createdTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.PoolInformation
  ) extends zio.aws.pinpointsmsvoicev2.model.PoolInformation.ReadOnly {
    override val poolArn: String = impl.poolArn(): String
    override val poolId: String = impl.poolId(): String
    override val status: zio.aws.pinpointsmsvoicev2.model.PoolStatus =
      zio.aws.pinpointsmsvoicev2.model.PoolStatus.wrap(impl.status())
    override val messageType: zio.aws.pinpointsmsvoicev2.model.MessageType =
      zio.aws.pinpointsmsvoicev2.model.MessageType.wrap(impl.messageType())
    override val twoWayEnabled: PrimitiveBoolean =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .PrimitiveBoolean(impl.twoWayEnabled())
    override val twoWayChannelArn: Optional[TwoWayChannelArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.twoWayChannelArn())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.primitives.TwoWayChannelArn(value)
        )
    override val selfManagedOptOutsEnabled: PrimitiveBoolean =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .PrimitiveBoolean(impl.selfManagedOptOutsEnabled())
    override val optOutListName: OptOutListName =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .OptOutListName(impl.optOutListName())
    override val sharedRoutesEnabled: PrimitiveBoolean =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .PrimitiveBoolean(impl.sharedRoutesEnabled())
    override val deletionProtectionEnabled: PrimitiveBoolean =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .PrimitiveBoolean(impl.deletionProtectionEnabled())
    override val createdTimestamp: Timestamp =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .Timestamp(impl.createdTimestamp())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.PoolInformation
  ): zio.aws.pinpointsmsvoicev2.model.PoolInformation.ReadOnly = new Wrapper(
    impl
  )
}
