package zio.aws.pinpointsmsvoicev2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointsmsvoicev2.model.primitives.{
  PrimitiveBoolean,
  Timestamp,
  PhoneNumber,
  OptOutListName
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class PutOptedOutNumberResponse(
    optOutListArn: Optional[String] = Optional.Absent,
    optOutListName: Optional[OptOutListName] = Optional.Absent,
    optedOutNumber: Optional[PhoneNumber] = Optional.Absent,
    optedOutTimestamp: Optional[Timestamp] = Optional.Absent,
    endUserOptedOut: Optional[PrimitiveBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutOptedOutNumberResponse = {
    import PutOptedOutNumberResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutOptedOutNumberResponse
      .builder()
      .optionallyWith(optOutListArn.map(value => value: java.lang.String))(
        _.optOutListArn
      )
      .optionallyWith(
        optOutListName.map(value =>
          OptOutListName.unwrap(value): java.lang.String
        )
      )(_.optOutListName)
      .optionallyWith(
        optedOutNumber.map(value => PhoneNumber.unwrap(value): java.lang.String)
      )(_.optedOutNumber)
      .optionallyWith(
        optedOutTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.optedOutTimestamp)
      .optionallyWith(
        endUserOptedOut.map(value =>
          PrimitiveBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.endUserOptedOut)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.PutOptedOutNumberResponse.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.PutOptedOutNumberResponse
      .wrap(buildAwsValue())
}
object PutOptedOutNumberResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutOptedOutNumberResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.PutOptedOutNumberResponse =
      zio.aws.pinpointsmsvoicev2.model.PutOptedOutNumberResponse(
        optOutListArn.map(value => value),
        optOutListName.map(value => value),
        optedOutNumber.map(value => value),
        optedOutTimestamp.map(value => value),
        endUserOptedOut.map(value => value)
      )
    def optOutListArn: Optional[String]
    def optOutListName: Optional[OptOutListName]
    def optedOutNumber: Optional[PhoneNumber]
    def optedOutTimestamp: Optional[Timestamp]
    def endUserOptedOut: Optional[PrimitiveBoolean]
    def getOptOutListArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("optOutListArn", optOutListArn)
    def getOptOutListName: ZIO[Any, AwsError, OptOutListName] =
      AwsError.unwrapOptionField("optOutListName", optOutListName)
    def getOptedOutNumber: ZIO[Any, AwsError, PhoneNumber] =
      AwsError.unwrapOptionField("optedOutNumber", optedOutNumber)
    def getOptedOutTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("optedOutTimestamp", optedOutTimestamp)
    def getEndUserOptedOut: ZIO[Any, AwsError, PrimitiveBoolean] =
      AwsError.unwrapOptionField("endUserOptedOut", endUserOptedOut)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutOptedOutNumberResponse
  ) extends zio.aws.pinpointsmsvoicev2.model.PutOptedOutNumberResponse.ReadOnly {
    override val optOutListArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.optOutListArn())
      .map(value => value: String)
    override val optOutListName: Optional[OptOutListName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optOutListName())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.primitives.OptOutListName(value)
        )
    override val optedOutNumber: Optional[PhoneNumber] = zio.aws.core.internal
      .optionalFromNullable(impl.optedOutNumber())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.PhoneNumber(value)
      )
    override val optedOutTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.optedOutTimestamp())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.Timestamp(value)
      )
    override val endUserOptedOut: Optional[PrimitiveBoolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endUserOptedOut())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.primitives.PrimitiveBoolean(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.PutOptedOutNumberResponse
  ): zio.aws.pinpointsmsvoicev2.model.PutOptedOutNumberResponse.ReadOnly =
    new Wrapper(impl)
}
