package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.PhoneNumberIdOrArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ReleasePhoneNumberRequest(phoneNumberId: PhoneNumberIdOrArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.ReleasePhoneNumberRequest = {
    import ReleasePhoneNumberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.ReleasePhoneNumberRequest
      .builder()
      .phoneNumberId(PhoneNumberIdOrArn.unwrap(phoneNumberId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.ReleasePhoneNumberRequest.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.ReleasePhoneNumberRequest
      .wrap(buildAwsValue())
}
object ReleasePhoneNumberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.ReleasePhoneNumberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.ReleasePhoneNumberRequest =
      zio.aws.pinpointsmsvoicev2.model.ReleasePhoneNumberRequest(phoneNumberId)
    def phoneNumberId: PhoneNumberIdOrArn
    def getPhoneNumberId: ZIO[Any, Nothing, PhoneNumberIdOrArn] =
      ZIO.succeed(phoneNumberId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.ReleasePhoneNumberRequest
  ) extends zio.aws.pinpointsmsvoicev2.model.ReleasePhoneNumberRequest.ReadOnly {
    override val phoneNumberId: PhoneNumberIdOrArn =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .PhoneNumberIdOrArn(impl.phoneNumberId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.ReleasePhoneNumberRequest
  ): zio.aws.pinpointsmsvoicev2.model.ReleasePhoneNumberRequest.ReadOnly =
    new Wrapper(impl)
}
