package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.{
  RegistrationId,
  PoolIdOrArn,
  IsoCountryCode,
  ClientToken,
  OptOutListNameOrArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RequestPhoneNumberRequest(
    isoCountryCode: IsoCountryCode,
    messageType: zio.aws.pinpointsmsvoicev2.model.MessageType,
    numberCapabilities: Iterable[
      zio.aws.pinpointsmsvoicev2.model.NumberCapability
    ],
    numberType: zio.aws.pinpointsmsvoicev2.model.RequestableNumberType,
    optOutListName: Optional[OptOutListNameOrArn] = Optional.Absent,
    poolId: Optional[PoolIdOrArn] = Optional.Absent,
    registrationId: Optional[RegistrationId] = Optional.Absent,
    deletionProtectionEnabled: Optional[Boolean] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.pinpointsmsvoicev2.model.Tag]] =
      Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.RequestPhoneNumberRequest = {
    import RequestPhoneNumberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.RequestPhoneNumberRequest
      .builder()
      .isoCountryCode(IsoCountryCode.unwrap(isoCountryCode): java.lang.String)
      .messageType(messageType.unwrap)
      .numberCapabilitiesWithStrings(numberCapabilities.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .numberType(numberType.unwrap)
      .optionallyWith(
        optOutListName.map(value =>
          OptOutListNameOrArn.unwrap(value): java.lang.String
        )
      )(_.optOutListName)
      .optionallyWith(
        poolId.map(value => PoolIdOrArn.unwrap(value): java.lang.String)
      )(_.poolId)
      .optionallyWith(
        registrationId.map(value =>
          RegistrationId.unwrap(value): java.lang.String
        )
      )(_.registrationId)
      .optionallyWith(
        deletionProtectionEnabled.map(value => value: java.lang.Boolean)
      )(_.deletionProtectionEnabled)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.RequestPhoneNumberRequest.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.RequestPhoneNumberRequest
      .wrap(buildAwsValue())
}
object RequestPhoneNumberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.RequestPhoneNumberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.RequestPhoneNumberRequest =
      zio.aws.pinpointsmsvoicev2.model.RequestPhoneNumberRequest(
        isoCountryCode,
        messageType,
        numberCapabilities,
        numberType,
        optOutListName.map(value => value),
        poolId.map(value => value),
        registrationId.map(value => value),
        deletionProtectionEnabled.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken.map(value => value)
      )
    def isoCountryCode: IsoCountryCode
    def messageType: zio.aws.pinpointsmsvoicev2.model.MessageType
    def numberCapabilities
        : List[zio.aws.pinpointsmsvoicev2.model.NumberCapability]
    def numberType: zio.aws.pinpointsmsvoicev2.model.RequestableNumberType
    def optOutListName: Optional[OptOutListNameOrArn]
    def poolId: Optional[PoolIdOrArn]
    def registrationId: Optional[RegistrationId]
    def deletionProtectionEnabled: Optional[Boolean]
    def tags: Optional[List[zio.aws.pinpointsmsvoicev2.model.Tag.ReadOnly]]
    def clientToken: Optional[ClientToken]
    def getIsoCountryCode: ZIO[Any, Nothing, IsoCountryCode] =
      ZIO.succeed(isoCountryCode)
    def getMessageType
        : ZIO[Any, Nothing, zio.aws.pinpointsmsvoicev2.model.MessageType] =
      ZIO.succeed(messageType)
    def getNumberCapabilities: ZIO[Any, Nothing, List[
      zio.aws.pinpointsmsvoicev2.model.NumberCapability
    ]] = ZIO.succeed(numberCapabilities)
    def getNumberType: ZIO[
      Any,
      Nothing,
      zio.aws.pinpointsmsvoicev2.model.RequestableNumberType
    ] = ZIO.succeed(numberType)
    def getOptOutListName: ZIO[Any, AwsError, OptOutListNameOrArn] =
      AwsError.unwrapOptionField("optOutListName", optOutListName)
    def getPoolId: ZIO[Any, AwsError, PoolIdOrArn] =
      AwsError.unwrapOptionField("poolId", poolId)
    def getRegistrationId: ZIO[Any, AwsError, RegistrationId] =
      AwsError.unwrapOptionField("registrationId", registrationId)
    def getDeletionProtectionEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("deletionProtectionEnabled", deletionProtectionEnabled)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.pinpointsmsvoicev2.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.RequestPhoneNumberRequest
  ) extends zio.aws.pinpointsmsvoicev2.model.RequestPhoneNumberRequest.ReadOnly {
    override val isoCountryCode: IsoCountryCode =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .IsoCountryCode(impl.isoCountryCode())
    override val messageType: zio.aws.pinpointsmsvoicev2.model.MessageType =
      zio.aws.pinpointsmsvoicev2.model.MessageType.wrap(impl.messageType())
    override val numberCapabilities
        : List[zio.aws.pinpointsmsvoicev2.model.NumberCapability] = impl
      .numberCapabilities()
      .asScala
      .map { item =>
        zio.aws.pinpointsmsvoicev2.model.NumberCapability.wrap(item)
      }
      .toList
    override val numberType
        : zio.aws.pinpointsmsvoicev2.model.RequestableNumberType =
      zio.aws.pinpointsmsvoicev2.model.RequestableNumberType
        .wrap(impl.numberType())
    override val optOutListName: Optional[OptOutListNameOrArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optOutListName())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.primitives.OptOutListNameOrArn(value)
        )
    override val poolId: Optional[PoolIdOrArn] = zio.aws.core.internal
      .optionalFromNullable(impl.poolId())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.PoolIdOrArn(value)
      )
    override val registrationId: Optional[RegistrationId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.registrationId())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.primitives.RegistrationId(value)
        )
    override val deletionProtectionEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletionProtectionEnabled())
        .map(value => value: Boolean)
    override val tags
        : Optional[List[zio.aws.pinpointsmsvoicev2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpointsmsvoicev2.model.Tag.wrap(item)
          }.toList
        )
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.ClientToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.RequestPhoneNumberRequest
  ): zio.aws.pinpointsmsvoicev2.model.RequestPhoneNumberRequest.ReadOnly =
    new Wrapper(impl)
}
