package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SendTextMessageResponse(
    messageId: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendTextMessageResponse = {
    import SendTextMessageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendTextMessageResponse
      .builder()
      .optionallyWith(messageId.map(value => value: java.lang.String))(
        _.messageId
      )
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.SendTextMessageResponse.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.SendTextMessageResponse
      .wrap(buildAwsValue())
}
object SendTextMessageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendTextMessageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.SendTextMessageResponse =
      zio.aws.pinpointsmsvoicev2.model
        .SendTextMessageResponse(messageId.map(value => value))
    def messageId: Optional[String]
    def getMessageId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("messageId", messageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendTextMessageResponse
  ) extends zio.aws.pinpointsmsvoicev2.model.SendTextMessageResponse.ReadOnly {
    override val messageId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.messageId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendTextMessageResponse
  ): zio.aws.pinpointsmsvoicev2.model.SendTextMessageResponse.ReadOnly =
    new Wrapper(impl)
}
