package zio.aws.pinpointsmsvoicev2.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointsmsvoicev2.model.primitives.{
  TimeToLive,
  ConfigurationSetNameOrArn,
  MaxPrice,
  PrimitiveBoolean,
  ContextKey,
  PhoneNumber,
  VoiceMessageOriginationIdentity,
  ContextValue,
  VoiceMessageBody
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class SendVoiceMessageRequest(
    destinationPhoneNumber: PhoneNumber,
    originationIdentity: VoiceMessageOriginationIdentity,
    messageBody: Optional[VoiceMessageBody] = Optional.Absent,
    messageBodyTextType: Optional[
      zio.aws.pinpointsmsvoicev2.model.VoiceMessageBodyTextType
    ] = Optional.Absent,
    voiceId: Optional[zio.aws.pinpointsmsvoicev2.model.VoiceId] =
      Optional.Absent,
    configurationSetName: Optional[ConfigurationSetNameOrArn] = Optional.Absent,
    maxPricePerMinute: Optional[MaxPrice] = Optional.Absent,
    timeToLive: Optional[TimeToLive] = Optional.Absent,
    context: Optional[Map[ContextKey, ContextValue]] = Optional.Absent,
    dryRun: Optional[PrimitiveBoolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendVoiceMessageRequest = {
    import SendVoiceMessageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendVoiceMessageRequest
      .builder()
      .destinationPhoneNumber(
        PhoneNumber.unwrap(destinationPhoneNumber): java.lang.String
      )
      .originationIdentity(
        VoiceMessageOriginationIdentity.unwrap(
          originationIdentity
        ): java.lang.String
      )
      .optionallyWith(
        messageBody.map(value =>
          VoiceMessageBody.unwrap(value): java.lang.String
        )
      )(_.messageBody)
      .optionallyWith(messageBodyTextType.map(value => value.unwrap))(
        _.messageBodyTextType
      )
      .optionallyWith(voiceId.map(value => value.unwrap))(_.voiceId)
      .optionallyWith(
        configurationSetName.map(value =>
          ConfigurationSetNameOrArn.unwrap(value): java.lang.String
        )
      )(_.configurationSetName)
      .optionallyWith(
        maxPricePerMinute.map(value => MaxPrice.unwrap(value): java.lang.String)
      )(_.maxPricePerMinute)
      .optionallyWith(
        timeToLive.map(value => TimeToLive.unwrap(value): Integer)
      )(_.timeToLive)
      .optionallyWith(
        context.map(value =>
          value
            .map({ case (key, value) =>
              (ContextKey.unwrap(key): java.lang.String) -> (ContextValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.context)
      .optionallyWith(
        dryRun.map(value => PrimitiveBoolean.unwrap(value): java.lang.Boolean)
      )(_.dryRun)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.SendVoiceMessageRequest.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.SendVoiceMessageRequest
      .wrap(buildAwsValue())
}
object SendVoiceMessageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendVoiceMessageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.SendVoiceMessageRequest =
      zio.aws.pinpointsmsvoicev2.model.SendVoiceMessageRequest(
        destinationPhoneNumber,
        originationIdentity,
        messageBody.map(value => value),
        messageBodyTextType.map(value => value),
        voiceId.map(value => value),
        configurationSetName.map(value => value),
        maxPricePerMinute.map(value => value),
        timeToLive.map(value => value),
        context.map(value => value),
        dryRun.map(value => value)
      )
    def destinationPhoneNumber: PhoneNumber
    def originationIdentity: VoiceMessageOriginationIdentity
    def messageBody: Optional[VoiceMessageBody]
    def messageBodyTextType
        : Optional[zio.aws.pinpointsmsvoicev2.model.VoiceMessageBodyTextType]
    def voiceId: Optional[zio.aws.pinpointsmsvoicev2.model.VoiceId]
    def configurationSetName: Optional[ConfigurationSetNameOrArn]
    def maxPricePerMinute: Optional[MaxPrice]
    def timeToLive: Optional[TimeToLive]
    def context: Optional[Map[ContextKey, ContextValue]]
    def dryRun: Optional[PrimitiveBoolean]
    def getDestinationPhoneNumber: ZIO[Any, Nothing, PhoneNumber] =
      ZIO.succeed(destinationPhoneNumber)
    def getOriginationIdentity
        : ZIO[Any, Nothing, VoiceMessageOriginationIdentity] =
      ZIO.succeed(originationIdentity)
    def getMessageBody: ZIO[Any, AwsError, VoiceMessageBody] =
      AwsError.unwrapOptionField("messageBody", messageBody)
    def getMessageBodyTextType: ZIO[
      Any,
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.VoiceMessageBodyTextType
    ] = AwsError.unwrapOptionField("messageBodyTextType", messageBodyTextType)
    def getVoiceId
        : ZIO[Any, AwsError, zio.aws.pinpointsmsvoicev2.model.VoiceId] =
      AwsError.unwrapOptionField("voiceId", voiceId)
    def getConfigurationSetName: ZIO[Any, AwsError, ConfigurationSetNameOrArn] =
      AwsError.unwrapOptionField("configurationSetName", configurationSetName)
    def getMaxPricePerMinute: ZIO[Any, AwsError, MaxPrice] =
      AwsError.unwrapOptionField("maxPricePerMinute", maxPricePerMinute)
    def getTimeToLive: ZIO[Any, AwsError, TimeToLive] =
      AwsError.unwrapOptionField("timeToLive", timeToLive)
    def getContext: ZIO[Any, AwsError, Map[ContextKey, ContextValue]] =
      AwsError.unwrapOptionField("context", context)
    def getDryRun: ZIO[Any, AwsError, PrimitiveBoolean] =
      AwsError.unwrapOptionField("dryRun", dryRun)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendVoiceMessageRequest
  ) extends zio.aws.pinpointsmsvoicev2.model.SendVoiceMessageRequest.ReadOnly {
    override val destinationPhoneNumber: PhoneNumber =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .PhoneNumber(impl.destinationPhoneNumber())
    override val originationIdentity: VoiceMessageOriginationIdentity =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .VoiceMessageOriginationIdentity(impl.originationIdentity())
    override val messageBody: Optional[VoiceMessageBody] = zio.aws.core.internal
      .optionalFromNullable(impl.messageBody())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.VoiceMessageBody(value)
      )
    override val messageBodyTextType
        : Optional[zio.aws.pinpointsmsvoicev2.model.VoiceMessageBodyTextType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.messageBodyTextType())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.VoiceMessageBodyTextType.wrap(value)
        )
    override val voiceId: Optional[zio.aws.pinpointsmsvoicev2.model.VoiceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.voiceId())
        .map(value => zio.aws.pinpointsmsvoicev2.model.VoiceId.wrap(value))
    override val configurationSetName: Optional[ConfigurationSetNameOrArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationSetName())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.primitives
            .ConfigurationSetNameOrArn(value)
        )
    override val maxPricePerMinute: Optional[MaxPrice] = zio.aws.core.internal
      .optionalFromNullable(impl.maxPricePerMinute())
      .map(value => zio.aws.pinpointsmsvoicev2.model.primitives.MaxPrice(value))
    override val timeToLive: Optional[TimeToLive] = zio.aws.core.internal
      .optionalFromNullable(impl.timeToLive())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.TimeToLive(value)
      )
    override val context: Optional[Map[ContextKey, ContextValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.context())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.pinpointsmsvoicev2.model.primitives
                .ContextKey(key) -> zio.aws.pinpointsmsvoicev2.model.primitives
                .ContextValue(value)
            })
            .toMap
        )
    override val dryRun: Optional[PrimitiveBoolean] = zio.aws.core.internal
      .optionalFromNullable(impl.dryRun())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.PrimitiveBoolean(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.SendVoiceMessageRequest
  ): zio.aws.pinpointsmsvoicev2.model.SendVoiceMessageRequest.ReadOnly =
    new Wrapper(impl)
}
