package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.{
  IsoCountryCode,
  SenderIdOrArn
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SenderIdAndCountry(
    senderId: SenderIdOrArn,
    isoCountryCode: IsoCountryCode
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.SenderIdAndCountry = {
    import SenderIdAndCountry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.SenderIdAndCountry
      .builder()
      .senderId(SenderIdOrArn.unwrap(senderId): java.lang.String)
      .isoCountryCode(IsoCountryCode.unwrap(isoCountryCode): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.pinpointsmsvoicev2.model.SenderIdAndCountry.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.SenderIdAndCountry.wrap(buildAwsValue())
}
object SenderIdAndCountry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.SenderIdAndCountry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.SenderIdAndCountry =
      zio.aws.pinpointsmsvoicev2.model
        .SenderIdAndCountry(senderId, isoCountryCode)
    def senderId: SenderIdOrArn
    def isoCountryCode: IsoCountryCode
    def getSenderId: ZIO[Any, Nothing, SenderIdOrArn] = ZIO.succeed(senderId)
    def getIsoCountryCode: ZIO[Any, Nothing, IsoCountryCode] =
      ZIO.succeed(isoCountryCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.SenderIdAndCountry
  ) extends zio.aws.pinpointsmsvoicev2.model.SenderIdAndCountry.ReadOnly {
    override val senderId: SenderIdOrArn =
      zio.aws.pinpointsmsvoicev2.model.primitives.SenderIdOrArn(impl.senderId())
    override val isoCountryCode: IsoCountryCode =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .IsoCountryCode(impl.isoCountryCode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.SenderIdAndCountry
  ): zio.aws.pinpointsmsvoicev2.model.SenderIdAndCountry.ReadOnly = new Wrapper(
    impl
  )
}
