package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.FilterValue
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SenderIdFilter(
    name: zio.aws.pinpointsmsvoicev2.model.SenderIdFilterName,
    values: Iterable[FilterValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.SenderIdFilter = {
    import SenderIdFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.SenderIdFilter
      .builder()
      .name(name.unwrap)
      .values(values.map { item =>
        FilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.pinpointsmsvoicev2.model.SenderIdFilter.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.SenderIdFilter.wrap(buildAwsValue())
}
object SenderIdFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.SenderIdFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.SenderIdFilter =
      zio.aws.pinpointsmsvoicev2.model.SenderIdFilter(name, values)
    def name: zio.aws.pinpointsmsvoicev2.model.SenderIdFilterName
    def values: List[FilterValue]
    def getName: ZIO[
      Any,
      Nothing,
      zio.aws.pinpointsmsvoicev2.model.SenderIdFilterName
    ] = ZIO.succeed(name)
    def getValues: ZIO[Any, Nothing, List[FilterValue]] = ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.SenderIdFilter
  ) extends zio.aws.pinpointsmsvoicev2.model.SenderIdFilter.ReadOnly {
    override val name: zio.aws.pinpointsmsvoicev2.model.SenderIdFilterName =
      zio.aws.pinpointsmsvoicev2.model.SenderIdFilterName.wrap(impl.name())
    override val values: List[FilterValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.pinpointsmsvoicev2.model.primitives.FilterValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.SenderIdFilter
  ): zio.aws.pinpointsmsvoicev2.model.SenderIdFilter.ReadOnly = new Wrapper(
    impl
  )
}
