package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.{IsoCountryCode, SenderId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SenderIdInformation(
    senderIdArn: String,
    senderId: SenderId,
    isoCountryCode: IsoCountryCode,
    messageTypes: Iterable[zio.aws.pinpointsmsvoicev2.model.MessageType],
    monthlyLeasingPrice: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.SenderIdInformation = {
    import SenderIdInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.SenderIdInformation
      .builder()
      .senderIdArn(senderIdArn: java.lang.String)
      .senderId(SenderId.unwrap(senderId): java.lang.String)
      .isoCountryCode(IsoCountryCode.unwrap(isoCountryCode): java.lang.String)
      .messageTypesWithStrings(messageTypes.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .monthlyLeasingPrice(monthlyLeasingPrice: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.SenderIdInformation.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.SenderIdInformation.wrap(buildAwsValue())
}
object SenderIdInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.SenderIdInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.SenderIdInformation =
      zio.aws.pinpointsmsvoicev2.model.SenderIdInformation(
        senderIdArn,
        senderId,
        isoCountryCode,
        messageTypes,
        monthlyLeasingPrice
      )
    def senderIdArn: String
    def senderId: SenderId
    def isoCountryCode: IsoCountryCode
    def messageTypes: List[zio.aws.pinpointsmsvoicev2.model.MessageType]
    def monthlyLeasingPrice: String
    def getSenderIdArn: ZIO[Any, Nothing, String] = ZIO.succeed(senderIdArn)
    def getSenderId: ZIO[Any, Nothing, SenderId] = ZIO.succeed(senderId)
    def getIsoCountryCode: ZIO[Any, Nothing, IsoCountryCode] =
      ZIO.succeed(isoCountryCode)
    def getMessageTypes: ZIO[Any, Nothing, List[
      zio.aws.pinpointsmsvoicev2.model.MessageType
    ]] = ZIO.succeed(messageTypes)
    def getMonthlyLeasingPrice: ZIO[Any, Nothing, String] =
      ZIO.succeed(monthlyLeasingPrice)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.SenderIdInformation
  ) extends zio.aws.pinpointsmsvoicev2.model.SenderIdInformation.ReadOnly {
    override val senderIdArn: String = impl.senderIdArn(): String
    override val senderId: SenderId =
      zio.aws.pinpointsmsvoicev2.model.primitives.SenderId(impl.senderId())
    override val isoCountryCode: IsoCountryCode =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .IsoCountryCode(impl.isoCountryCode())
    override val messageTypes
        : List[zio.aws.pinpointsmsvoicev2.model.MessageType] = impl
      .messageTypes()
      .asScala
      .map { item =>
        zio.aws.pinpointsmsvoicev2.model.MessageType.wrap(item)
      }
      .toList
    override val monthlyLeasingPrice: String =
      impl.monthlyLeasingPrice(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.SenderIdInformation
  ): zio.aws.pinpointsmsvoicev2.model.SenderIdInformation.ReadOnly =
    new Wrapper(impl)
}
