package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.{
  SenderId,
  ConfigurationSetName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SetDefaultSenderIdResponse(
    configurationSetArn: Optional[String] = Optional.Absent,
    configurationSetName: Optional[ConfigurationSetName] = Optional.Absent,
    senderId: Optional[SenderId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetDefaultSenderIdResponse = {
    import SetDefaultSenderIdResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetDefaultSenderIdResponse
      .builder()
      .optionallyWith(
        configurationSetArn.map(value => value: java.lang.String)
      )(_.configurationSetArn)
      .optionallyWith(
        configurationSetName.map(value =>
          ConfigurationSetName.unwrap(value): java.lang.String
        )
      )(_.configurationSetName)
      .optionallyWith(
        senderId.map(value => SenderId.unwrap(value): java.lang.String)
      )(_.senderId)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.SetDefaultSenderIdResponse.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.SetDefaultSenderIdResponse
      .wrap(buildAwsValue())
}
object SetDefaultSenderIdResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetDefaultSenderIdResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointsmsvoicev2.model.SetDefaultSenderIdResponse =
      zio.aws.pinpointsmsvoicev2.model.SetDefaultSenderIdResponse(
        configurationSetArn.map(value => value),
        configurationSetName.map(value => value),
        senderId.map(value => value)
      )
    def configurationSetArn: Optional[String]
    def configurationSetName: Optional[ConfigurationSetName]
    def senderId: Optional[SenderId]
    def getConfigurationSetArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("configurationSetArn", configurationSetArn)
    def getConfigurationSetName: ZIO[Any, AwsError, ConfigurationSetName] =
      AwsError.unwrapOptionField("configurationSetName", configurationSetName)
    def getSenderId: ZIO[Any, AwsError, SenderId] =
      AwsError.unwrapOptionField("senderId", senderId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetDefaultSenderIdResponse
  ) extends zio.aws.pinpointsmsvoicev2.model.SetDefaultSenderIdResponse.ReadOnly {
    override val configurationSetArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.configurationSetArn())
      .map(value => value: String)
    override val configurationSetName: Optional[ConfigurationSetName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationSetName())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.primitives
            .ConfigurationSetName(value)
        )
    override val senderId: Optional[SenderId] = zio.aws.core.internal
      .optionalFromNullable(impl.senderId())
      .map(value => zio.aws.pinpointsmsvoicev2.model.primitives.SenderId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.SetDefaultSenderIdResponse
  ): zio.aws.pinpointsmsvoicev2.model.SetDefaultSenderIdResponse.ReadOnly =
    new Wrapper(impl)
}
