package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.{
  PrimitiveBoolean,
  PrimitiveLong
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SpendLimit(
    name: zio.aws.pinpointsmsvoicev2.model.SpendLimitName,
    enforcedLimit: PrimitiveLong,
    maxLimit: PrimitiveLong,
    overridden: PrimitiveBoolean
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.SpendLimit = {
    import SpendLimit.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.SpendLimit
      .builder()
      .name(name.unwrap)
      .enforcedLimit(PrimitiveLong.unwrap(enforcedLimit): java.lang.Long)
      .maxLimit(PrimitiveLong.unwrap(maxLimit): java.lang.Long)
      .overridden(PrimitiveBoolean.unwrap(overridden): java.lang.Boolean)
      .build()
  }
  def asReadOnly: zio.aws.pinpointsmsvoicev2.model.SpendLimit.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.SpendLimit.wrap(buildAwsValue())
}
object SpendLimit {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.SpendLimit
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.SpendLimit =
      zio.aws.pinpointsmsvoicev2.model.SpendLimit(
        name,
        enforcedLimit,
        maxLimit,
        overridden
      )
    def name: zio.aws.pinpointsmsvoicev2.model.SpendLimitName
    def enforcedLimit: PrimitiveLong
    def maxLimit: PrimitiveLong
    def overridden: PrimitiveBoolean
    def getName
        : ZIO[Any, Nothing, zio.aws.pinpointsmsvoicev2.model.SpendLimitName] =
      ZIO.succeed(name)
    def getEnforcedLimit: ZIO[Any, Nothing, PrimitiveLong] =
      ZIO.succeed(enforcedLimit)
    def getMaxLimit: ZIO[Any, Nothing, PrimitiveLong] = ZIO.succeed(maxLimit)
    def getOverridden: ZIO[Any, Nothing, PrimitiveBoolean] =
      ZIO.succeed(overridden)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.SpendLimit
  ) extends zio.aws.pinpointsmsvoicev2.model.SpendLimit.ReadOnly {
    override val name: zio.aws.pinpointsmsvoicev2.model.SpendLimitName =
      zio.aws.pinpointsmsvoicev2.model.SpendLimitName.wrap(impl.name())
    override val enforcedLimit: PrimitiveLong =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .PrimitiveLong(impl.enforcedLimit())
    override val maxLimit: PrimitiveLong =
      zio.aws.pinpointsmsvoicev2.model.primitives.PrimitiveLong(impl.maxLimit())
    override val overridden: PrimitiveBoolean =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .PrimitiveBoolean(impl.overridden())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.SpendLimit
  ): zio.aws.pinpointsmsvoicev2.model.SpendLimit.ReadOnly = new Wrapper(impl)
}
