package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.{
  OptOutListNameOrArn,
  TwoWayChannelArn,
  PhoneNumberIdOrArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdatePhoneNumberRequest(
    phoneNumberId: PhoneNumberIdOrArn,
    twoWayEnabled: Optional[Boolean] = Optional.Absent,
    twoWayChannelArn: Optional[TwoWayChannelArn] = Optional.Absent,
    selfManagedOptOutsEnabled: Optional[Boolean] = Optional.Absent,
    optOutListName: Optional[OptOutListNameOrArn] = Optional.Absent,
    deletionProtectionEnabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdatePhoneNumberRequest = {
    import UpdatePhoneNumberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdatePhoneNumberRequest
      .builder()
      .phoneNumberId(PhoneNumberIdOrArn.unwrap(phoneNumberId): java.lang.String)
      .optionallyWith(twoWayEnabled.map(value => value: java.lang.Boolean))(
        _.twoWayEnabled
      )
      .optionallyWith(
        twoWayChannelArn.map(value =>
          TwoWayChannelArn.unwrap(value): java.lang.String
        )
      )(_.twoWayChannelArn)
      .optionallyWith(
        selfManagedOptOutsEnabled.map(value => value: java.lang.Boolean)
      )(_.selfManagedOptOutsEnabled)
      .optionallyWith(
        optOutListName.map(value =>
          OptOutListNameOrArn.unwrap(value): java.lang.String
        )
      )(_.optOutListName)
      .optionallyWith(
        deletionProtectionEnabled.map(value => value: java.lang.Boolean)
      )(_.deletionProtectionEnabled)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.UpdatePhoneNumberRequest.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.UpdatePhoneNumberRequest
      .wrap(buildAwsValue())
}
object UpdatePhoneNumberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdatePhoneNumberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.UpdatePhoneNumberRequest =
      zio.aws.pinpointsmsvoicev2.model.UpdatePhoneNumberRequest(
        phoneNumberId,
        twoWayEnabled.map(value => value),
        twoWayChannelArn.map(value => value),
        selfManagedOptOutsEnabled.map(value => value),
        optOutListName.map(value => value),
        deletionProtectionEnabled.map(value => value)
      )
    def phoneNumberId: PhoneNumberIdOrArn
    def twoWayEnabled: Optional[Boolean]
    def twoWayChannelArn: Optional[TwoWayChannelArn]
    def selfManagedOptOutsEnabled: Optional[Boolean]
    def optOutListName: Optional[OptOutListNameOrArn]
    def deletionProtectionEnabled: Optional[Boolean]
    def getPhoneNumberId: ZIO[Any, Nothing, PhoneNumberIdOrArn] =
      ZIO.succeed(phoneNumberId)
    def getTwoWayEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("twoWayEnabled", twoWayEnabled)
    def getTwoWayChannelArn: ZIO[Any, AwsError, TwoWayChannelArn] =
      AwsError.unwrapOptionField("twoWayChannelArn", twoWayChannelArn)
    def getSelfManagedOptOutsEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("selfManagedOptOutsEnabled", selfManagedOptOutsEnabled)
    def getOptOutListName: ZIO[Any, AwsError, OptOutListNameOrArn] =
      AwsError.unwrapOptionField("optOutListName", optOutListName)
    def getDeletionProtectionEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("deletionProtectionEnabled", deletionProtectionEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdatePhoneNumberRequest
  ) extends zio.aws.pinpointsmsvoicev2.model.UpdatePhoneNumberRequest.ReadOnly {
    override val phoneNumberId: PhoneNumberIdOrArn =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .PhoneNumberIdOrArn(impl.phoneNumberId())
    override val twoWayEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.twoWayEnabled())
      .map(value => value: Boolean)
    override val twoWayChannelArn: Optional[TwoWayChannelArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.twoWayChannelArn())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.primitives.TwoWayChannelArn(value)
        )
    override val selfManagedOptOutsEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.selfManagedOptOutsEnabled())
        .map(value => value: Boolean)
    override val optOutListName: Optional[OptOutListNameOrArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optOutListName())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.primitives.OptOutListNameOrArn(value)
        )
    override val deletionProtectionEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletionProtectionEnabled())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdatePhoneNumberRequest
  ): zio.aws.pinpointsmsvoicev2.model.UpdatePhoneNumberRequest.ReadOnly =
    new Wrapper(impl)
}
