package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.{
  OptOutListNameOrArn,
  TwoWayChannelArn,
  PoolIdOrArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdatePoolRequest(
    poolId: PoolIdOrArn,
    twoWayEnabled: Optional[Boolean] = Optional.Absent,
    twoWayChannelArn: Optional[TwoWayChannelArn] = Optional.Absent,
    selfManagedOptOutsEnabled: Optional[Boolean] = Optional.Absent,
    optOutListName: Optional[OptOutListNameOrArn] = Optional.Absent,
    sharedRoutesEnabled: Optional[Boolean] = Optional.Absent,
    deletionProtectionEnabled: Optional[Boolean] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdatePoolRequest = {
    import UpdatePoolRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdatePoolRequest
      .builder()
      .poolId(PoolIdOrArn.unwrap(poolId): java.lang.String)
      .optionallyWith(twoWayEnabled.map(value => value: java.lang.Boolean))(
        _.twoWayEnabled
      )
      .optionallyWith(
        twoWayChannelArn.map(value =>
          TwoWayChannelArn.unwrap(value): java.lang.String
        )
      )(_.twoWayChannelArn)
      .optionallyWith(
        selfManagedOptOutsEnabled.map(value => value: java.lang.Boolean)
      )(_.selfManagedOptOutsEnabled)
      .optionallyWith(
        optOutListName.map(value =>
          OptOutListNameOrArn.unwrap(value): java.lang.String
        )
      )(_.optOutListName)
      .optionallyWith(
        sharedRoutesEnabled.map(value => value: java.lang.Boolean)
      )(_.sharedRoutesEnabled)
      .optionallyWith(
        deletionProtectionEnabled.map(value => value: java.lang.Boolean)
      )(_.deletionProtectionEnabled)
      .build()
  }
  def asReadOnly: zio.aws.pinpointsmsvoicev2.model.UpdatePoolRequest.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.UpdatePoolRequest.wrap(buildAwsValue())
}
object UpdatePoolRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdatePoolRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.UpdatePoolRequest =
      zio.aws.pinpointsmsvoicev2.model.UpdatePoolRequest(
        poolId,
        twoWayEnabled.map(value => value),
        twoWayChannelArn.map(value => value),
        selfManagedOptOutsEnabled.map(value => value),
        optOutListName.map(value => value),
        sharedRoutesEnabled.map(value => value),
        deletionProtectionEnabled.map(value => value)
      )
    def poolId: PoolIdOrArn
    def twoWayEnabled: Optional[Boolean]
    def twoWayChannelArn: Optional[TwoWayChannelArn]
    def selfManagedOptOutsEnabled: Optional[Boolean]
    def optOutListName: Optional[OptOutListNameOrArn]
    def sharedRoutesEnabled: Optional[Boolean]
    def deletionProtectionEnabled: Optional[Boolean]
    def getPoolId: ZIO[Any, Nothing, PoolIdOrArn] = ZIO.succeed(poolId)
    def getTwoWayEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("twoWayEnabled", twoWayEnabled)
    def getTwoWayChannelArn: ZIO[Any, AwsError, TwoWayChannelArn] =
      AwsError.unwrapOptionField("twoWayChannelArn", twoWayChannelArn)
    def getSelfManagedOptOutsEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("selfManagedOptOutsEnabled", selfManagedOptOutsEnabled)
    def getOptOutListName: ZIO[Any, AwsError, OptOutListNameOrArn] =
      AwsError.unwrapOptionField("optOutListName", optOutListName)
    def getSharedRoutesEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("sharedRoutesEnabled", sharedRoutesEnabled)
    def getDeletionProtectionEnabled: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("deletionProtectionEnabled", deletionProtectionEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdatePoolRequest
  ) extends zio.aws.pinpointsmsvoicev2.model.UpdatePoolRequest.ReadOnly {
    override val poolId: PoolIdOrArn =
      zio.aws.pinpointsmsvoicev2.model.primitives.PoolIdOrArn(impl.poolId())
    override val twoWayEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.twoWayEnabled())
      .map(value => value: Boolean)
    override val twoWayChannelArn: Optional[TwoWayChannelArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.twoWayChannelArn())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.primitives.TwoWayChannelArn(value)
        )
    override val selfManagedOptOutsEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.selfManagedOptOutsEnabled())
        .map(value => value: Boolean)
    override val optOutListName: Optional[OptOutListNameOrArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.optOutListName())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.primitives.OptOutListNameOrArn(value)
        )
    override val sharedRoutesEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.sharedRoutesEnabled())
      .map(value => value: Boolean)
    override val deletionProtectionEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletionProtectionEnabled())
        .map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.UpdatePoolRequest
  ): zio.aws.pinpointsmsvoicev2.model.UpdatePoolRequest.ReadOnly = new Wrapper(
    impl
  )
}
