package zio.aws.pinpointsmsvoicev2
import zio.aws.pinpointsmsvoicev2.model.ListTagsForResourceResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.pinpointsmsvoicev2.model.{
  CreateEventDestinationRequest,
  RequestPhoneNumberRequest,
  DeleteTextMessageSpendLimitOverrideRequest,
  SetDefaultMessageTypeRequest,
  ListPoolOriginationIdentitiesResponse,
  PoolInformation,
  DeleteDefaultSenderIdRequest,
  DescribeConfigurationSetsRequest,
  SpendLimit,
  DescribePoolsRequest,
  ConfigurationSetInformation,
  PhoneNumberInformation,
  UpdateEventDestinationResponse,
  SetDefaultSenderIdResponse,
  SenderIdInformation,
  DisassociateOriginationIdentityRequest,
  DescribeAccountLimitsResponse,
  DeleteConfigurationSetResponse,
  DeleteConfigurationSetRequest,
  ReleasePhoneNumberRequest,
  CreateOptOutListResponse,
  DeleteOptedOutNumberResponse,
  RequestPhoneNumberResponse,
  DeletePoolRequest,
  DeleteKeywordRequest,
  DeleteDefaultSenderIdResponse,
  DescribePhoneNumbersRequest,
  UpdatePhoneNumberRequest,
  ListTagsForResourceRequest,
  SetVoiceMessageSpendLimitOverrideResponse,
  DescribeKeywordsRequest,
  UpdatePoolRequest,
  CreateConfigurationSetRequest,
  CreateConfigurationSetResponse,
  AccountLimit,
  OriginationIdentityMetadata,
  CreateEventDestinationResponse,
  DeleteEventDestinationResponse,
  DeleteKeywordResponse,
  CreatePoolRequest,
  DescribeSpendLimitsRequest,
  DisassociateOriginationIdentityResponse,
  DescribeOptOutListsResponse,
  ListTagsForResourceResponse,
  SendVoiceMessageResponse,
  AccountAttribute,
  UntagResourceResponse,
  ListPoolOriginationIdentitiesRequest,
  UpdatePoolResponse,
  DescribeConfigurationSetsResponse,
  DeleteVoiceMessageSpendLimitOverrideResponse,
  DescribePoolsResponse,
  SetDefaultSenderIdRequest,
  DescribeOptedOutNumbersResponse,
  KeywordInformation,
  SendTextMessageRequest,
  SetTextMessageSpendLimitOverrideRequest,
  OptOutListInformation,
  DeleteOptOutListResponse,
  DescribeSenderIdsRequest,
  PutKeywordRequest,
  SetTextMessageSpendLimitOverrideResponse,
  OptedOutNumberInformation,
  DeleteTextMessageSpendLimitOverrideResponse,
  DescribeSenderIdsResponse,
  DeleteEventDestinationRequest,
  UntagResourceRequest,
  UpdatePhoneNumberResponse,
  DescribeOptOutListsRequest,
  DescribeKeywordsResponse,
  DescribeAccountAttributesRequest,
  PutOptedOutNumberRequest,
  PutKeywordResponse,
  DeleteVoiceMessageSpendLimitOverrideRequest,
  SendVoiceMessageRequest,
  DescribeAccountLimitsRequest,
  CreateOptOutListRequest,
  AssociateOriginationIdentityRequest,
  DeleteDefaultMessageTypeRequest,
  CreatePoolResponse,
  DescribePhoneNumbersResponse,
  AssociateOriginationIdentityResponse,
  DeletePoolResponse,
  TagResourceResponse,
  UpdateEventDestinationRequest,
  SetDefaultMessageTypeResponse,
  SendTextMessageResponse,
  DescribeAccountAttributesResponse,
  DescribeSpendLimitsResponse,
  PutOptedOutNumberResponse,
  DeleteDefaultMessageTypeResponse,
  TagResourceRequest,
  ReleasePhoneNumberResponse,
  DeleteOptOutListRequest,
  DeleteOptedOutNumberRequest,
  DescribeOptedOutNumbersRequest,
  SetVoiceMessageSpendLimitOverrideRequest
}
import zio.aws.core.{AwsServiceBase, StreamingOutputResult, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import software.amazon.awssdk.services.pinpointsmsvoicev2.{
  PinpointSmsVoiceV2AsyncClientBuilder,
  PinpointSmsVoiceV2AsyncClient
}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters.*
trait PinpointSmsVoiceV2 extends AspectSupport[PinpointSmsVoiceV2] {
  val api: PinpointSmsVoiceV2AsyncClient
  def deleteKeyword(
      request: zio.aws.pinpointsmsvoicev2.model.DeleteKeywordRequest
  ): IO[
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DeleteKeywordResponse.ReadOnly
  ]
  def deleteOptedOutNumber(
      request: zio.aws.pinpointsmsvoicev2.model.DeleteOptedOutNumberRequest
  ): IO[
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DeleteOptedOutNumberResponse.ReadOnly
  ]
  def requestPhoneNumber(
      request: zio.aws.pinpointsmsvoicev2.model.RequestPhoneNumberRequest
  ): IO[
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.RequestPhoneNumberResponse.ReadOnly
  ]
  def deleteDefaultSenderId(
      request: zio.aws.pinpointsmsvoicev2.model.DeleteDefaultSenderIdRequest
  ): IO[
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DeleteDefaultSenderIdResponse.ReadOnly
  ]
  def describeKeywords(
      request: zio.aws.pinpointsmsvoicev2.model.DescribeKeywordsRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.pinpointsmsvoicev2.model.DescribeKeywordsResponse.ReadOnly,
    zio.aws.pinpointsmsvoicev2.model.KeywordInformation.ReadOnly
  ]]
  def describeKeywordsPaginated(
      request: zio.aws.pinpointsmsvoicev2.model.DescribeKeywordsRequest
  ): IO[
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DescribeKeywordsResponse.ReadOnly
  ]
  def sendTextMessage(
      request: zio.aws.pinpointsmsvoicev2.model.SendTextMessageRequest
  ): IO[
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.SendTextMessageResponse.ReadOnly
  ]
  def releasePhoneNumber(
      request: zio.aws.pinpointsmsvoicev2.model.ReleasePhoneNumberRequest
  ): IO[
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.ReleasePhoneNumberResponse.ReadOnly
  ]
  def describePools(
      request: zio.aws.pinpointsmsvoicev2.model.DescribePoolsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.PoolInformation.ReadOnly
  ]
  def describePoolsPaginated(
      request: zio.aws.pinpointsmsvoicev2.model.DescribePoolsRequest
  ): IO[
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DescribePoolsResponse.ReadOnly
  ]
  def describeOptOutLists(
      request: zio.aws.pinpointsmsvoicev2.model.DescribeOptOutListsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.OptOutListInformation.ReadOnly
  ]
  def describeOptOutListsPaginated(
      request: zio.aws.pinpointsmsvoicev2.model.DescribeOptOutListsRequest
  ): IO[
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DescribeOptOutListsResponse.ReadOnly
  ]
  def deleteEventDestination(
      request: zio.aws.pinpointsmsvoicev2.model.DeleteEventDestinationRequest
  ): IO[
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DeleteEventDestinationResponse.ReadOnly
  ]
  def createOptOutList(
      request: zio.aws.pinpointsmsvoicev2.model.CreateOptOutListRequest
  ): IO[
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.CreateOptOutListResponse.ReadOnly
  ]
  def describeAccountLimits(
      request: zio.aws.pinpointsmsvoicev2.model.DescribeAccountLimitsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.AccountLimit.ReadOnly
  ]
  def describeAccountLimitsPaginated(
      request: zio.aws.pinpointsmsvoicev2.model.DescribeAccountLimitsRequest
  ): IO[
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DescribeAccountLimitsResponse.ReadOnly
  ]
  def listPoolOriginationIdentities(
      request: zio.aws.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse.ReadOnly,
    zio.aws.pinpointsmsvoicev2.model.OriginationIdentityMetadata.ReadOnly
  ]]
  def listPoolOriginationIdentitiesPaginated(
      request: zio.aws.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest
  ): IO[
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse.ReadOnly
  ]
  def deleteTextMessageSpendLimitOverride(
      request: zio.aws.pinpointsmsvoicev2.model.DeleteTextMessageSpendLimitOverrideRequest
  ): IO[
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DeleteTextMessageSpendLimitOverrideResponse.ReadOnly
  ]
  def createPool(
      request: zio.aws.pinpointsmsvoicev2.model.CreatePoolRequest
  ): IO[AwsError, zio.aws.pinpointsmsvoicev2.model.CreatePoolResponse.ReadOnly]
  def updatePhoneNumber(
      request: zio.aws.pinpointsmsvoicev2.model.UpdatePhoneNumberRequest
  ): IO[
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.UpdatePhoneNumberResponse.ReadOnly
  ]
  def putOptedOutNumber(
      request: zio.aws.pinpointsmsvoicev2.model.PutOptedOutNumberRequest
  ): IO[
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.PutOptedOutNumberResponse.ReadOnly
  ]
  def putKeyword(
      request: zio.aws.pinpointsmsvoicev2.model.PutKeywordRequest
  ): IO[AwsError, zio.aws.pinpointsmsvoicev2.model.PutKeywordResponse.ReadOnly]
  def updatePool(
      request: zio.aws.pinpointsmsvoicev2.model.UpdatePoolRequest
  ): IO[AwsError, zio.aws.pinpointsmsvoicev2.model.UpdatePoolResponse.ReadOnly]
  def untagResource(
      request: zio.aws.pinpointsmsvoicev2.model.UntagResourceRequest
  ): IO[
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.UntagResourceResponse.ReadOnly
  ]
  def deleteDefaultMessageType(
      request: zio.aws.pinpointsmsvoicev2.model.DeleteDefaultMessageTypeRequest
  ): IO[
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DeleteDefaultMessageTypeResponse.ReadOnly
  ]
  def describeSenderIds(
      request: zio.aws.pinpointsmsvoicev2.model.DescribeSenderIdsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.SenderIdInformation.ReadOnly
  ]
  def describeSenderIdsPaginated(
      request: zio.aws.pinpointsmsvoicev2.model.DescribeSenderIdsRequest
  ): IO[
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DescribeSenderIdsResponse.ReadOnly
  ]
  def deletePool(
      request: zio.aws.pinpointsmsvoicev2.model.DeletePoolRequest
  ): IO[AwsError, zio.aws.pinpointsmsvoicev2.model.DeletePoolResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.pinpointsmsvoicev2.model.ListTagsForResourceRequest
  ): IO[AwsError, ReadOnly]
  def tagResource(
      request: zio.aws.pinpointsmsvoicev2.model.TagResourceRequest
  ): IO[AwsError, zio.aws.pinpointsmsvoicev2.model.TagResourceResponse.ReadOnly]
  def describeConfigurationSets(
      request: zio.aws.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.ConfigurationSetInformation.ReadOnly
  ]
  def describeConfigurationSetsPaginated(
      request: zio.aws.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest
  ): IO[
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DescribeConfigurationSetsResponse.ReadOnly
  ]
  def setVoiceMessageSpendLimitOverride(
      request: zio.aws.pinpointsmsvoicev2.model.SetVoiceMessageSpendLimitOverrideRequest
  ): IO[
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.SetVoiceMessageSpendLimitOverrideResponse.ReadOnly
  ]
  def deleteConfigurationSet(
      request: zio.aws.pinpointsmsvoicev2.model.DeleteConfigurationSetRequest
  ): IO[
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DeleteConfigurationSetResponse.ReadOnly
  ]
  def createConfigurationSet(
      request: zio.aws.pinpointsmsvoicev2.model.CreateConfigurationSetRequest
  ): IO[
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.CreateConfigurationSetResponse.ReadOnly
  ]
  def deleteOptOutList(
      request: zio.aws.pinpointsmsvoicev2.model.DeleteOptOutListRequest
  ): IO[
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DeleteOptOutListResponse.ReadOnly
  ]
  def sendVoiceMessage(
      request: zio.aws.pinpointsmsvoicev2.model.SendVoiceMessageRequest
  ): IO[
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.SendVoiceMessageResponse.ReadOnly
  ]
  def disassociateOriginationIdentity(
      request: zio.aws.pinpointsmsvoicev2.model.DisassociateOriginationIdentityRequest
  ): IO[
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DisassociateOriginationIdentityResponse.ReadOnly
  ]
  def createEventDestination(
      request: zio.aws.pinpointsmsvoicev2.model.CreateEventDestinationRequest
  ): IO[
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.CreateEventDestinationResponse.ReadOnly
  ]
  def describeSpendLimits(
      request: zio.aws.pinpointsmsvoicev2.model.DescribeSpendLimitsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.SpendLimit.ReadOnly
  ]
  def describeSpendLimitsPaginated(
      request: zio.aws.pinpointsmsvoicev2.model.DescribeSpendLimitsRequest
  ): IO[
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DescribeSpendLimitsResponse.ReadOnly
  ]
  def describePhoneNumbers(
      request: zio.aws.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.PhoneNumberInformation.ReadOnly
  ]
  def describePhoneNumbersPaginated(
      request: zio.aws.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest
  ): IO[
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DescribePhoneNumbersResponse.ReadOnly
  ]
  def describeAccountAttributes(
      request: zio.aws.pinpointsmsvoicev2.model.DescribeAccountAttributesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.AccountAttribute.ReadOnly
  ]
  def describeAccountAttributesPaginated(
      request: zio.aws.pinpointsmsvoicev2.model.DescribeAccountAttributesRequest
  ): IO[
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DescribeAccountAttributesResponse.ReadOnly
  ]
  def setDefaultSenderId(
      request: zio.aws.pinpointsmsvoicev2.model.SetDefaultSenderIdRequest
  ): IO[
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.SetDefaultSenderIdResponse.ReadOnly
  ]
  def deleteVoiceMessageSpendLimitOverride(
      request: zio.aws.pinpointsmsvoicev2.model.DeleteVoiceMessageSpendLimitOverrideRequest
  ): IO[
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DeleteVoiceMessageSpendLimitOverrideResponse.ReadOnly
  ]
  def setTextMessageSpendLimitOverride(
      request: zio.aws.pinpointsmsvoicev2.model.SetTextMessageSpendLimitOverrideRequest
  ): IO[
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.SetTextMessageSpendLimitOverrideResponse.ReadOnly
  ]
  def associateOriginationIdentity(
      request: zio.aws.pinpointsmsvoicev2.model.AssociateOriginationIdentityRequest
  ): IO[
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.AssociateOriginationIdentityResponse.ReadOnly
  ]
  def updateEventDestination(
      request: zio.aws.pinpointsmsvoicev2.model.UpdateEventDestinationRequest
  ): IO[
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.UpdateEventDestinationResponse.ReadOnly
  ]
  def describeOptedOutNumbers(
      request: zio.aws.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest
  ): ZIO[Any, AwsError, StreamingOutputResult[
    Any,
    zio.aws.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse.ReadOnly,
    zio.aws.pinpointsmsvoicev2.model.OptedOutNumberInformation.ReadOnly
  ]]
  def describeOptedOutNumbersPaginated(
      request: zio.aws.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest
  ): IO[
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse.ReadOnly
  ]
  def setDefaultMessageType(
      request: zio.aws.pinpointsmsvoicev2.model.SetDefaultMessageTypeRequest
  ): IO[
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.SetDefaultMessageTypeResponse.ReadOnly
  ]
}
object PinpointSmsVoiceV2 {
  val live: ZLayer[AwsConfig, java.lang.Throwable, PinpointSmsVoiceV2] =
    customized(identity)
  def customized(
      customization: PinpointSmsVoiceV2AsyncClientBuilder => PinpointSmsVoiceV2AsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, PinpointSmsVoiceV2] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: PinpointSmsVoiceV2AsyncClientBuilder => PinpointSmsVoiceV2AsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, PinpointSmsVoiceV2] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = PinpointSmsVoiceV2AsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[
      PinpointSmsVoiceV2AsyncClient,
      PinpointSmsVoiceV2AsyncClientBuilder
    ](builder);
    b1 <- awsConfig.configureHttpClient[
      PinpointSmsVoiceV2AsyncClient,
      PinpointSmsVoiceV2AsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new PinpointSmsVoiceV2Impl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class PinpointSmsVoiceV2Impl[R](
      override val api: PinpointSmsVoiceV2AsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends PinpointSmsVoiceV2
      with AwsServiceBase[R] {
    override val serviceName: String = "PinpointSmsVoiceV2"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): PinpointSmsVoiceV2Impl[R1] =
      new PinpointSmsVoiceV2Impl(api, newAspect, r)
    def deleteKeyword(
        request: zio.aws.pinpointsmsvoicev2.model.DeleteKeywordRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.DeleteKeywordResponse.ReadOnly
    ] = asyncRequestResponse[DeleteKeywordRequest, DeleteKeywordResponse](
      "deleteKeyword",
      api.deleteKeyword
    )(request.buildAwsValue())
      .map(zio.aws.pinpointsmsvoicev2.model.DeleteKeywordResponse.wrap)
      .provideEnvironment(r)
    def deleteOptedOutNumber(
        request: zio.aws.pinpointsmsvoicev2.model.DeleteOptedOutNumberRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.DeleteOptedOutNumberResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteOptedOutNumberRequest,
      DeleteOptedOutNumberResponse
    ]("deleteOptedOutNumber", api.deleteOptedOutNumber)(request.buildAwsValue())
      .map(zio.aws.pinpointsmsvoicev2.model.DeleteOptedOutNumberResponse.wrap)
      .provideEnvironment(r)
    def requestPhoneNumber(
        request: zio.aws.pinpointsmsvoicev2.model.RequestPhoneNumberRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.RequestPhoneNumberResponse.ReadOnly
    ] = asyncRequestResponse[
      RequestPhoneNumberRequest,
      RequestPhoneNumberResponse
    ]("requestPhoneNumber", api.requestPhoneNumber)(request.buildAwsValue())
      .map(zio.aws.pinpointsmsvoicev2.model.RequestPhoneNumberResponse.wrap)
      .provideEnvironment(r)
    def deleteDefaultSenderId(
        request: zio.aws.pinpointsmsvoicev2.model.DeleteDefaultSenderIdRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.DeleteDefaultSenderIdResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteDefaultSenderIdRequest,
      DeleteDefaultSenderIdResponse
    ]("deleteDefaultSenderId", api.deleteDefaultSenderId)(
      request.buildAwsValue()
    ).map(zio.aws.pinpointsmsvoicev2.model.DeleteDefaultSenderIdResponse.wrap)
      .provideEnvironment(r)
    def describeKeywords(
        request: zio.aws.pinpointsmsvoicev2.model.DescribeKeywordsRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.pinpointsmsvoicev2.model.DescribeKeywordsResponse.ReadOnly,
      zio.aws.pinpointsmsvoicev2.model.KeywordInformation.ReadOnly
    ]] = asyncPaginatedRequest[
      DescribeKeywordsRequest,
      DescribeKeywordsResponse,
      KeywordInformation
    ](
      "describeKeywords",
      api.describeKeywords,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.keywords().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.pinpointsmsvoicev2.model.DescribeKeywordsResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.pinpointsmsvoicev2.model.KeywordInformation.wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def describeKeywordsPaginated(
        request: zio.aws.pinpointsmsvoicev2.model.DescribeKeywordsRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.DescribeKeywordsResponse.ReadOnly
    ] = asyncRequestResponse[DescribeKeywordsRequest, DescribeKeywordsResponse](
      "describeKeywords",
      api.describeKeywords
    )(request.buildAwsValue())
      .map(zio.aws.pinpointsmsvoicev2.model.DescribeKeywordsResponse.wrap)
      .provideEnvironment(r)
    def sendTextMessage(
        request: zio.aws.pinpointsmsvoicev2.model.SendTextMessageRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.SendTextMessageResponse.ReadOnly
    ] = asyncRequestResponse[SendTextMessageRequest, SendTextMessageResponse](
      "sendTextMessage",
      api.sendTextMessage
    )(request.buildAwsValue())
      .map(zio.aws.pinpointsmsvoicev2.model.SendTextMessageResponse.wrap)
      .provideEnvironment(r)
    def releasePhoneNumber(
        request: zio.aws.pinpointsmsvoicev2.model.ReleasePhoneNumberRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.ReleasePhoneNumberResponse.ReadOnly
    ] = asyncRequestResponse[
      ReleasePhoneNumberRequest,
      ReleasePhoneNumberResponse
    ]("releasePhoneNumber", api.releasePhoneNumber)(request.buildAwsValue())
      .map(zio.aws.pinpointsmsvoicev2.model.ReleasePhoneNumberResponse.wrap)
      .provideEnvironment(r)
    def describePools(
        request: zio.aws.pinpointsmsvoicev2.model.DescribePoolsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.PoolInformation.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribePoolsRequest,
      DescribePoolsResponse,
      PoolInformation
    ](
      "describePools",
      api.describePools,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.pools().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.pinpointsmsvoicev2.model.PoolInformation.wrap(item))
      .provideEnvironment(r)
    def describePoolsPaginated(
        request: zio.aws.pinpointsmsvoicev2.model.DescribePoolsRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.DescribePoolsResponse.ReadOnly
    ] = asyncRequestResponse[DescribePoolsRequest, DescribePoolsResponse](
      "describePools",
      api.describePools
    )(request.buildAwsValue())
      .map(zio.aws.pinpointsmsvoicev2.model.DescribePoolsResponse.wrap)
      .provideEnvironment(r)
    def describeOptOutLists(
        request: zio.aws.pinpointsmsvoicev2.model.DescribeOptOutListsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.OptOutListInformation.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeOptOutListsRequest,
      DescribeOptOutListsResponse,
      OptOutListInformation
    ](
      "describeOptOutLists",
      api.describeOptOutLists,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.optOutLists().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.pinpointsmsvoicev2.model.OptOutListInformation.wrap(item)
      )
      .provideEnvironment(r)
    def describeOptOutListsPaginated(
        request: zio.aws.pinpointsmsvoicev2.model.DescribeOptOutListsRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.DescribeOptOutListsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeOptOutListsRequest,
      DescribeOptOutListsResponse
    ]("describeOptOutLists", api.describeOptOutLists)(request.buildAwsValue())
      .map(zio.aws.pinpointsmsvoicev2.model.DescribeOptOutListsResponse.wrap)
      .provideEnvironment(r)
    def deleteEventDestination(
        request: zio.aws.pinpointsmsvoicev2.model.DeleteEventDestinationRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.DeleteEventDestinationResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteEventDestinationRequest,
      DeleteEventDestinationResponse
    ]("deleteEventDestination", api.deleteEventDestination)(
      request.buildAwsValue()
    ).map(zio.aws.pinpointsmsvoicev2.model.DeleteEventDestinationResponse.wrap)
      .provideEnvironment(r)
    def createOptOutList(
        request: zio.aws.pinpointsmsvoicev2.model.CreateOptOutListRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.CreateOptOutListResponse.ReadOnly
    ] = asyncRequestResponse[CreateOptOutListRequest, CreateOptOutListResponse](
      "createOptOutList",
      api.createOptOutList
    )(request.buildAwsValue())
      .map(zio.aws.pinpointsmsvoicev2.model.CreateOptOutListResponse.wrap)
      .provideEnvironment(r)
    def describeAccountLimits(
        request: zio.aws.pinpointsmsvoicev2.model.DescribeAccountLimitsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.AccountLimit.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeAccountLimitsRequest,
      DescribeAccountLimitsResponse,
      AccountLimit
    ](
      "describeAccountLimits",
      api.describeAccountLimits,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.accountLimits().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.pinpointsmsvoicev2.model.AccountLimit.wrap(item))
      .provideEnvironment(r)
    def describeAccountLimitsPaginated(
        request: zio.aws.pinpointsmsvoicev2.model.DescribeAccountLimitsRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.DescribeAccountLimitsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeAccountLimitsRequest,
      DescribeAccountLimitsResponse
    ]("describeAccountLimits", api.describeAccountLimits)(
      request.buildAwsValue()
    ).map(zio.aws.pinpointsmsvoicev2.model.DescribeAccountLimitsResponse.wrap)
      .provideEnvironment(r)
    def listPoolOriginationIdentities(
        request: zio.aws.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse.ReadOnly,
      zio.aws.pinpointsmsvoicev2.model.OriginationIdentityMetadata.ReadOnly
    ]] = asyncPaginatedRequest[
      ListPoolOriginationIdentitiesRequest,
      ListPoolOriginationIdentitiesResponse,
      OriginationIdentityMetadata
    ](
      "listPoolOriginationIdentities",
      api.listPoolOriginationIdentities,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.originationIdentities().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.pinpointsmsvoicev2.model.OriginationIdentityMetadata
                .wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def listPoolOriginationIdentitiesPaginated(
        request: zio.aws.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListPoolOriginationIdentitiesRequest,
      ListPoolOriginationIdentitiesResponse
    ]("listPoolOriginationIdentities", api.listPoolOriginationIdentities)(
      request.buildAwsValue()
    ).map(
      zio.aws.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse.wrap
    ).provideEnvironment(r)
    def deleteTextMessageSpendLimitOverride(
        request: zio.aws.pinpointsmsvoicev2.model.DeleteTextMessageSpendLimitOverrideRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.DeleteTextMessageSpendLimitOverrideResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteTextMessageSpendLimitOverrideRequest,
      DeleteTextMessageSpendLimitOverrideResponse
    ](
      "deleteTextMessageSpendLimitOverride",
      api.deleteTextMessageSpendLimitOverride
    )(request.buildAwsValue())
      .map(
        zio.aws.pinpointsmsvoicev2.model.DeleteTextMessageSpendLimitOverrideResponse.wrap
      )
      .provideEnvironment(r)
    def createPool(
        request: zio.aws.pinpointsmsvoicev2.model.CreatePoolRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.CreatePoolResponse.ReadOnly
    ] = asyncRequestResponse[CreatePoolRequest, CreatePoolResponse](
      "createPool",
      api.createPool
    )(request.buildAwsValue())
      .map(zio.aws.pinpointsmsvoicev2.model.CreatePoolResponse.wrap)
      .provideEnvironment(r)
    def updatePhoneNumber(
        request: zio.aws.pinpointsmsvoicev2.model.UpdatePhoneNumberRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.UpdatePhoneNumberResponse.ReadOnly
    ] =
      asyncRequestResponse[UpdatePhoneNumberRequest, UpdatePhoneNumberResponse](
        "updatePhoneNumber",
        api.updatePhoneNumber
      )(request.buildAwsValue())
        .map(zio.aws.pinpointsmsvoicev2.model.UpdatePhoneNumberResponse.wrap)
        .provideEnvironment(r)
    def putOptedOutNumber(
        request: zio.aws.pinpointsmsvoicev2.model.PutOptedOutNumberRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.PutOptedOutNumberResponse.ReadOnly
    ] =
      asyncRequestResponse[PutOptedOutNumberRequest, PutOptedOutNumberResponse](
        "putOptedOutNumber",
        api.putOptedOutNumber
      )(request.buildAwsValue())
        .map(zio.aws.pinpointsmsvoicev2.model.PutOptedOutNumberResponse.wrap)
        .provideEnvironment(r)
    def putKeyword(
        request: zio.aws.pinpointsmsvoicev2.model.PutKeywordRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.PutKeywordResponse.ReadOnly
    ] = asyncRequestResponse[PutKeywordRequest, PutKeywordResponse](
      "putKeyword",
      api.putKeyword
    )(request.buildAwsValue())
      .map(zio.aws.pinpointsmsvoicev2.model.PutKeywordResponse.wrap)
      .provideEnvironment(r)
    def updatePool(
        request: zio.aws.pinpointsmsvoicev2.model.UpdatePoolRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.UpdatePoolResponse.ReadOnly
    ] = asyncRequestResponse[UpdatePoolRequest, UpdatePoolResponse](
      "updatePool",
      api.updatePool
    )(request.buildAwsValue())
      .map(zio.aws.pinpointsmsvoicev2.model.UpdatePoolResponse.wrap)
      .provideEnvironment(r)
    def untagResource(
        request: zio.aws.pinpointsmsvoicev2.model.UntagResourceRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
      "untagResource",
      api.untagResource
    )(request.buildAwsValue())
      .map(zio.aws.pinpointsmsvoicev2.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def deleteDefaultMessageType(
        request: zio.aws.pinpointsmsvoicev2.model.DeleteDefaultMessageTypeRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.DeleteDefaultMessageTypeResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteDefaultMessageTypeRequest,
      DeleteDefaultMessageTypeResponse
    ]("deleteDefaultMessageType", api.deleteDefaultMessageType)(
      request.buildAwsValue()
    ).map(
      zio.aws.pinpointsmsvoicev2.model.DeleteDefaultMessageTypeResponse.wrap
    ).provideEnvironment(r)
    def describeSenderIds(
        request: zio.aws.pinpointsmsvoicev2.model.DescribeSenderIdsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.SenderIdInformation.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeSenderIdsRequest,
      DescribeSenderIdsResponse,
      SenderIdInformation
    ](
      "describeSenderIds",
      api.describeSenderIds,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.senderIds().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.pinpointsmsvoicev2.model.SenderIdInformation.wrap(item)
      )
      .provideEnvironment(r)
    def describeSenderIdsPaginated(
        request: zio.aws.pinpointsmsvoicev2.model.DescribeSenderIdsRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.DescribeSenderIdsResponse.ReadOnly
    ] =
      asyncRequestResponse[DescribeSenderIdsRequest, DescribeSenderIdsResponse](
        "describeSenderIds",
        api.describeSenderIds
      )(request.buildAwsValue())
        .map(zio.aws.pinpointsmsvoicev2.model.DescribeSenderIdsResponse.wrap)
        .provideEnvironment(r)
    def deletePool(
        request: zio.aws.pinpointsmsvoicev2.model.DeletePoolRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.DeletePoolResponse.ReadOnly
    ] = asyncRequestResponse[DeletePoolRequest, DeletePoolResponse](
      "deletePool",
      api.deletePool
    )(request.buildAwsValue())
      .map(zio.aws.pinpointsmsvoicev2.model.DeletePoolResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.pinpointsmsvoicev2.model.ListTagsForResourceRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.pinpointsmsvoicev2.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.pinpointsmsvoicev2.model.TagResourceRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[TagResourceRequest, TagResourceResponse](
      "tagResource",
      api.tagResource
    )(request.buildAwsValue())
      .map(zio.aws.pinpointsmsvoicev2.model.TagResourceResponse.wrap)
      .provideEnvironment(r)
    def describeConfigurationSets(
        request: zio.aws.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.ConfigurationSetInformation.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeConfigurationSetsRequest,
      DescribeConfigurationSetsResponse,
      ConfigurationSetInformation
    ](
      "describeConfigurationSets",
      api.describeConfigurationSets,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.configurationSets().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.pinpointsmsvoicev2.model.ConfigurationSetInformation.wrap(item)
      )
      .provideEnvironment(r)
    def describeConfigurationSetsPaginated(
        request: zio.aws.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.DescribeConfigurationSetsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeConfigurationSetsRequest,
      DescribeConfigurationSetsResponse
    ]("describeConfigurationSets", api.describeConfigurationSets)(
      request.buildAwsValue()
    ).map(
      zio.aws.pinpointsmsvoicev2.model.DescribeConfigurationSetsResponse.wrap
    ).provideEnvironment(r)
    def setVoiceMessageSpendLimitOverride(
        request: zio.aws.pinpointsmsvoicev2.model.SetVoiceMessageSpendLimitOverrideRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.SetVoiceMessageSpendLimitOverrideResponse.ReadOnly
    ] = asyncRequestResponse[
      SetVoiceMessageSpendLimitOverrideRequest,
      SetVoiceMessageSpendLimitOverrideResponse
    ](
      "setVoiceMessageSpendLimitOverride",
      api.setVoiceMessageSpendLimitOverride
    )(request.buildAwsValue())
      .map(
        zio.aws.pinpointsmsvoicev2.model.SetVoiceMessageSpendLimitOverrideResponse.wrap
      )
      .provideEnvironment(r)
    def deleteConfigurationSet(
        request: zio.aws.pinpointsmsvoicev2.model.DeleteConfigurationSetRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.DeleteConfigurationSetResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteConfigurationSetRequest,
      DeleteConfigurationSetResponse
    ]("deleteConfigurationSet", api.deleteConfigurationSet)(
      request.buildAwsValue()
    ).map(zio.aws.pinpointsmsvoicev2.model.DeleteConfigurationSetResponse.wrap)
      .provideEnvironment(r)
    def createConfigurationSet(
        request: zio.aws.pinpointsmsvoicev2.model.CreateConfigurationSetRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.CreateConfigurationSetResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateConfigurationSetRequest,
      CreateConfigurationSetResponse
    ]("createConfigurationSet", api.createConfigurationSet)(
      request.buildAwsValue()
    ).map(zio.aws.pinpointsmsvoicev2.model.CreateConfigurationSetResponse.wrap)
      .provideEnvironment(r)
    def deleteOptOutList(
        request: zio.aws.pinpointsmsvoicev2.model.DeleteOptOutListRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.DeleteOptOutListResponse.ReadOnly
    ] = asyncRequestResponse[DeleteOptOutListRequest, DeleteOptOutListResponse](
      "deleteOptOutList",
      api.deleteOptOutList
    )(request.buildAwsValue())
      .map(zio.aws.pinpointsmsvoicev2.model.DeleteOptOutListResponse.wrap)
      .provideEnvironment(r)
    def sendVoiceMessage(
        request: zio.aws.pinpointsmsvoicev2.model.SendVoiceMessageRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.SendVoiceMessageResponse.ReadOnly
    ] = asyncRequestResponse[SendVoiceMessageRequest, SendVoiceMessageResponse](
      "sendVoiceMessage",
      api.sendVoiceMessage
    )(request.buildAwsValue())
      .map(zio.aws.pinpointsmsvoicev2.model.SendVoiceMessageResponse.wrap)
      .provideEnvironment(r)
    def disassociateOriginationIdentity(
        request: zio.aws.pinpointsmsvoicev2.model.DisassociateOriginationIdentityRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.DisassociateOriginationIdentityResponse.ReadOnly
    ] = asyncRequestResponse[
      DisassociateOriginationIdentityRequest,
      DisassociateOriginationIdentityResponse
    ]("disassociateOriginationIdentity", api.disassociateOriginationIdentity)(
      request.buildAwsValue()
    ).map(
      zio.aws.pinpointsmsvoicev2.model.DisassociateOriginationIdentityResponse.wrap
    ).provideEnvironment(r)
    def createEventDestination(
        request: zio.aws.pinpointsmsvoicev2.model.CreateEventDestinationRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.CreateEventDestinationResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateEventDestinationRequest,
      CreateEventDestinationResponse
    ]("createEventDestination", api.createEventDestination)(
      request.buildAwsValue()
    ).map(zio.aws.pinpointsmsvoicev2.model.CreateEventDestinationResponse.wrap)
      .provideEnvironment(r)
    def describeSpendLimits(
        request: zio.aws.pinpointsmsvoicev2.model.DescribeSpendLimitsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.SpendLimit.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeSpendLimitsRequest,
      DescribeSpendLimitsResponse,
      SpendLimit
    ](
      "describeSpendLimits",
      api.describeSpendLimits,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.spendLimits().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.pinpointsmsvoicev2.model.SpendLimit.wrap(item))
      .provideEnvironment(r)
    def describeSpendLimitsPaginated(
        request: zio.aws.pinpointsmsvoicev2.model.DescribeSpendLimitsRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.DescribeSpendLimitsResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeSpendLimitsRequest,
      DescribeSpendLimitsResponse
    ]("describeSpendLimits", api.describeSpendLimits)(request.buildAwsValue())
      .map(zio.aws.pinpointsmsvoicev2.model.DescribeSpendLimitsResponse.wrap)
      .provideEnvironment(r)
    def describePhoneNumbers(
        request: zio.aws.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.PhoneNumberInformation.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribePhoneNumbersRequest,
      DescribePhoneNumbersResponse,
      PhoneNumberInformation
    ](
      "describePhoneNumbers",
      api.describePhoneNumbers,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.phoneNumbers().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.pinpointsmsvoicev2.model.PhoneNumberInformation.wrap(item)
      )
      .provideEnvironment(r)
    def describePhoneNumbersPaginated(
        request: zio.aws.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.DescribePhoneNumbersResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribePhoneNumbersRequest,
      DescribePhoneNumbersResponse
    ]("describePhoneNumbers", api.describePhoneNumbers)(request.buildAwsValue())
      .map(zio.aws.pinpointsmsvoicev2.model.DescribePhoneNumbersResponse.wrap)
      .provideEnvironment(r)
    def describeAccountAttributes(
        request: zio.aws.pinpointsmsvoicev2.model.DescribeAccountAttributesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.AccountAttribute.ReadOnly
    ] = asyncSimplePaginatedRequest[
      DescribeAccountAttributesRequest,
      DescribeAccountAttributesResponse,
      AccountAttribute
    ](
      "describeAccountAttributes",
      api.describeAccountAttributes,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.accountAttributes().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.pinpointsmsvoicev2.model.AccountAttribute.wrap(item))
      .provideEnvironment(r)
    def describeAccountAttributesPaginated(
        request: zio.aws.pinpointsmsvoicev2.model.DescribeAccountAttributesRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.DescribeAccountAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeAccountAttributesRequest,
      DescribeAccountAttributesResponse
    ]("describeAccountAttributes", api.describeAccountAttributes)(
      request.buildAwsValue()
    ).map(
      zio.aws.pinpointsmsvoicev2.model.DescribeAccountAttributesResponse.wrap
    ).provideEnvironment(r)
    def setDefaultSenderId(
        request: zio.aws.pinpointsmsvoicev2.model.SetDefaultSenderIdRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.SetDefaultSenderIdResponse.ReadOnly
    ] = asyncRequestResponse[
      SetDefaultSenderIdRequest,
      SetDefaultSenderIdResponse
    ]("setDefaultSenderId", api.setDefaultSenderId)(request.buildAwsValue())
      .map(zio.aws.pinpointsmsvoicev2.model.SetDefaultSenderIdResponse.wrap)
      .provideEnvironment(r)
    def deleteVoiceMessageSpendLimitOverride(
        request: zio.aws.pinpointsmsvoicev2.model.DeleteVoiceMessageSpendLimitOverrideRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.DeleteVoiceMessageSpendLimitOverrideResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteVoiceMessageSpendLimitOverrideRequest,
      DeleteVoiceMessageSpendLimitOverrideResponse
    ](
      "deleteVoiceMessageSpendLimitOverride",
      api.deleteVoiceMessageSpendLimitOverride
    )(request.buildAwsValue())
      .map(
        zio.aws.pinpointsmsvoicev2.model.DeleteVoiceMessageSpendLimitOverrideResponse.wrap
      )
      .provideEnvironment(r)
    def setTextMessageSpendLimitOverride(
        request: zio.aws.pinpointsmsvoicev2.model.SetTextMessageSpendLimitOverrideRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.SetTextMessageSpendLimitOverrideResponse.ReadOnly
    ] = asyncRequestResponse[
      SetTextMessageSpendLimitOverrideRequest,
      SetTextMessageSpendLimitOverrideResponse
    ]("setTextMessageSpendLimitOverride", api.setTextMessageSpendLimitOverride)(
      request.buildAwsValue()
    ).map(
      zio.aws.pinpointsmsvoicev2.model.SetTextMessageSpendLimitOverrideResponse.wrap
    ).provideEnvironment(r)
    def associateOriginationIdentity(
        request: zio.aws.pinpointsmsvoicev2.model.AssociateOriginationIdentityRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.AssociateOriginationIdentityResponse.ReadOnly
    ] = asyncRequestResponse[
      AssociateOriginationIdentityRequest,
      AssociateOriginationIdentityResponse
    ]("associateOriginationIdentity", api.associateOriginationIdentity)(
      request.buildAwsValue()
    ).map(
      zio.aws.pinpointsmsvoicev2.model.AssociateOriginationIdentityResponse.wrap
    ).provideEnvironment(r)
    def updateEventDestination(
        request: zio.aws.pinpointsmsvoicev2.model.UpdateEventDestinationRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.UpdateEventDestinationResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateEventDestinationRequest,
      UpdateEventDestinationResponse
    ]("updateEventDestination", api.updateEventDestination)(
      request.buildAwsValue()
    ).map(zio.aws.pinpointsmsvoicev2.model.UpdateEventDestinationResponse.wrap)
      .provideEnvironment(r)
    def describeOptedOutNumbers(
        request: zio.aws.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest
    ): ZIO[Any, AwsError, StreamingOutputResult[
      Any,
      zio.aws.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse.ReadOnly,
      zio.aws.pinpointsmsvoicev2.model.OptedOutNumberInformation.ReadOnly
    ]] = asyncPaginatedRequest[
      DescribeOptedOutNumbersRequest,
      DescribeOptedOutNumbersResponse,
      OptedOutNumberInformation
    ](
      "describeOptedOutNumbers",
      api.describeOptedOutNumbers,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.optedOutNumbers().asScala)
    )(request.buildAwsValue())
      .map(result =>
        result
          .mapResponse(
            zio.aws.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse.wrap
          )
          .mapOutput(
            _.map(item =>
              zio.aws.pinpointsmsvoicev2.model.OptedOutNumberInformation
                .wrap(item)
            )
          )
          .provideEnvironment(r)
      )
      .provideEnvironment(r)
    def describeOptedOutNumbersPaginated(
        request: zio.aws.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeOptedOutNumbersRequest,
      DescribeOptedOutNumbersResponse
    ]("describeOptedOutNumbers", api.describeOptedOutNumbers)(
      request.buildAwsValue()
    ).map(zio.aws.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse.wrap)
      .provideEnvironment(r)
    def setDefaultMessageType(
        request: zio.aws.pinpointsmsvoicev2.model.SetDefaultMessageTypeRequest
    ): IO[
      AwsError,
      zio.aws.pinpointsmsvoicev2.model.SetDefaultMessageTypeResponse.ReadOnly
    ] = asyncRequestResponse[
      SetDefaultMessageTypeRequest,
      SetDefaultMessageTypeResponse
    ]("setDefaultMessageType", api.setDefaultMessageType)(
      request.buildAwsValue()
    ).map(zio.aws.pinpointsmsvoicev2.model.SetDefaultMessageTypeResponse.wrap)
      .provideEnvironment(r)
  }
  def deleteKeyword(
      request: zio.aws.pinpointsmsvoicev2.model.DeleteKeywordRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DeleteKeywordResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteKeyword(request))
  def deleteOptedOutNumber(
      request: zio.aws.pinpointsmsvoicev2.model.DeleteOptedOutNumberRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DeleteOptedOutNumberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteOptedOutNumber(request))
  def requestPhoneNumber(
      request: zio.aws.pinpointsmsvoicev2.model.RequestPhoneNumberRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.RequestPhoneNumberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.requestPhoneNumber(request))
  def deleteDefaultSenderId(
      request: zio.aws.pinpointsmsvoicev2.model.DeleteDefaultSenderIdRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DeleteDefaultSenderIdResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDefaultSenderId(request))
  def describeKeywords(
      request: zio.aws.pinpointsmsvoicev2.model.DescribeKeywordsRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    StreamingOutputResult[
      Any,
      zio.aws.pinpointsmsvoicev2.model.DescribeKeywordsResponse.ReadOnly,
      zio.aws.pinpointsmsvoicev2.model.KeywordInformation.ReadOnly
    ]
  ] = ZIO.serviceWithZIO(_.describeKeywords(request))
  def describeKeywordsPaginated(
      request: zio.aws.pinpointsmsvoicev2.model.DescribeKeywordsRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DescribeKeywordsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeKeywordsPaginated(request))
  def sendTextMessage(
      request: zio.aws.pinpointsmsvoicev2.model.SendTextMessageRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.SendTextMessageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendTextMessage(request))
  def releasePhoneNumber(
      request: zio.aws.pinpointsmsvoicev2.model.ReleasePhoneNumberRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.ReleasePhoneNumberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.releasePhoneNumber(request))
  def describePools(
      request: zio.aws.pinpointsmsvoicev2.model.DescribePoolsRequest
  ): ZStream[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.PoolInformation.ReadOnly
  ] = ZStream.serviceWithStream(_.describePools(request))
  def describePoolsPaginated(
      request: zio.aws.pinpointsmsvoicev2.model.DescribePoolsRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DescribePoolsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePoolsPaginated(request))
  def describeOptOutLists(
      request: zio.aws.pinpointsmsvoicev2.model.DescribeOptOutListsRequest
  ): ZStream[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.OptOutListInformation.ReadOnly
  ] = ZStream.serviceWithStream(_.describeOptOutLists(request))
  def describeOptOutListsPaginated(
      request: zio.aws.pinpointsmsvoicev2.model.DescribeOptOutListsRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DescribeOptOutListsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeOptOutListsPaginated(request))
  def deleteEventDestination(
      request: zio.aws.pinpointsmsvoicev2.model.DeleteEventDestinationRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DeleteEventDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEventDestination(request))
  def createOptOutList(
      request: zio.aws.pinpointsmsvoicev2.model.CreateOptOutListRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.CreateOptOutListResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createOptOutList(request))
  def describeAccountLimits(
      request: zio.aws.pinpointsmsvoicev2.model.DescribeAccountLimitsRequest
  ): ZStream[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.AccountLimit.ReadOnly
  ] = ZStream.serviceWithStream(_.describeAccountLimits(request))
  def describeAccountLimitsPaginated(
      request: zio.aws.pinpointsmsvoicev2.model.DescribeAccountLimitsRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DescribeAccountLimitsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAccountLimitsPaginated(request))
  def listPoolOriginationIdentities(
      request: zio.aws.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    StreamingOutputResult[
      Any,
      zio.aws.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse.ReadOnly,
      zio.aws.pinpointsmsvoicev2.model.OriginationIdentityMetadata.ReadOnly
    ]
  ] = ZIO.serviceWithZIO(_.listPoolOriginationIdentities(request))
  def listPoolOriginationIdentitiesPaginated(
      request: zio.aws.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.ListPoolOriginationIdentitiesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listPoolOriginationIdentitiesPaginated(request))
  def deleteTextMessageSpendLimitOverride(
      request: zio.aws.pinpointsmsvoicev2.model.DeleteTextMessageSpendLimitOverrideRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DeleteTextMessageSpendLimitOverrideResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteTextMessageSpendLimitOverride(request))
  def createPool(
      request: zio.aws.pinpointsmsvoicev2.model.CreatePoolRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.CreatePoolResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createPool(request))
  def updatePhoneNumber(
      request: zio.aws.pinpointsmsvoicev2.model.UpdatePhoneNumberRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.UpdatePhoneNumberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePhoneNumber(request))
  def putOptedOutNumber(
      request: zio.aws.pinpointsmsvoicev2.model.PutOptedOutNumberRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.PutOptedOutNumberResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putOptedOutNumber(request))
  def putKeyword(
      request: zio.aws.pinpointsmsvoicev2.model.PutKeywordRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.PutKeywordResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putKeyword(request))
  def updatePool(
      request: zio.aws.pinpointsmsvoicev2.model.UpdatePoolRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.UpdatePoolResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updatePool(request))
  def untagResource(
      request: zio.aws.pinpointsmsvoicev2.model.UntagResourceRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def deleteDefaultMessageType(
      request: zio.aws.pinpointsmsvoicev2.model.DeleteDefaultMessageTypeRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DeleteDefaultMessageTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDefaultMessageType(request))
  def describeSenderIds(
      request: zio.aws.pinpointsmsvoicev2.model.DescribeSenderIdsRequest
  ): ZStream[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.SenderIdInformation.ReadOnly
  ] = ZStream.serviceWithStream(_.describeSenderIds(request))
  def describeSenderIdsPaginated(
      request: zio.aws.pinpointsmsvoicev2.model.DescribeSenderIdsRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DescribeSenderIdsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSenderIdsPaginated(request))
  def deletePool(
      request: zio.aws.pinpointsmsvoicev2.model.DeletePoolRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DeletePoolResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deletePool(request))
  def listTagsForResource(
      request: zio.aws.pinpointsmsvoicev2.model.ListTagsForResourceRequest
  ): ZIO[zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(
      request: zio.aws.pinpointsmsvoicev2.model.TagResourceRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def describeConfigurationSets(
      request: zio.aws.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest
  ): ZStream[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.ConfigurationSetInformation.ReadOnly
  ] = ZStream.serviceWithStream(_.describeConfigurationSets(request))
  def describeConfigurationSetsPaginated(
      request: zio.aws.pinpointsmsvoicev2.model.DescribeConfigurationSetsRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DescribeConfigurationSetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeConfigurationSetsPaginated(request))
  def setVoiceMessageSpendLimitOverride(
      request: zio.aws.pinpointsmsvoicev2.model.SetVoiceMessageSpendLimitOverrideRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.SetVoiceMessageSpendLimitOverrideResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.setVoiceMessageSpendLimitOverride(request))
  def deleteConfigurationSet(
      request: zio.aws.pinpointsmsvoicev2.model.DeleteConfigurationSetRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DeleteConfigurationSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteConfigurationSet(request))
  def createConfigurationSet(
      request: zio.aws.pinpointsmsvoicev2.model.CreateConfigurationSetRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.CreateConfigurationSetResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createConfigurationSet(request))
  def deleteOptOutList(
      request: zio.aws.pinpointsmsvoicev2.model.DeleteOptOutListRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DeleteOptOutListResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteOptOutList(request))
  def sendVoiceMessage(
      request: zio.aws.pinpointsmsvoicev2.model.SendVoiceMessageRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.SendVoiceMessageResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.sendVoiceMessage(request))
  def disassociateOriginationIdentity(
      request: zio.aws.pinpointsmsvoicev2.model.DisassociateOriginationIdentityRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DisassociateOriginationIdentityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disassociateOriginationIdentity(request))
  def createEventDestination(
      request: zio.aws.pinpointsmsvoicev2.model.CreateEventDestinationRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.CreateEventDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createEventDestination(request))
  def describeSpendLimits(
      request: zio.aws.pinpointsmsvoicev2.model.DescribeSpendLimitsRequest
  ): ZStream[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.SpendLimit.ReadOnly
  ] = ZStream.serviceWithStream(_.describeSpendLimits(request))
  def describeSpendLimitsPaginated(
      request: zio.aws.pinpointsmsvoicev2.model.DescribeSpendLimitsRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DescribeSpendLimitsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeSpendLimitsPaginated(request))
  def describePhoneNumbers(
      request: zio.aws.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest
  ): ZStream[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.PhoneNumberInformation.ReadOnly
  ] = ZStream.serviceWithStream(_.describePhoneNumbers(request))
  def describePhoneNumbersPaginated(
      request: zio.aws.pinpointsmsvoicev2.model.DescribePhoneNumbersRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DescribePhoneNumbersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePhoneNumbersPaginated(request))
  def describeAccountAttributes(
      request: zio.aws.pinpointsmsvoicev2.model.DescribeAccountAttributesRequest
  ): ZStream[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.AccountAttribute.ReadOnly
  ] = ZStream.serviceWithStream(_.describeAccountAttributes(request))
  def describeAccountAttributesPaginated(
      request: zio.aws.pinpointsmsvoicev2.model.DescribeAccountAttributesRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DescribeAccountAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAccountAttributesPaginated(request))
  def setDefaultSenderId(
      request: zio.aws.pinpointsmsvoicev2.model.SetDefaultSenderIdRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.SetDefaultSenderIdResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.setDefaultSenderId(request))
  def deleteVoiceMessageSpendLimitOverride(
      request: zio.aws.pinpointsmsvoicev2.model.DeleteVoiceMessageSpendLimitOverrideRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DeleteVoiceMessageSpendLimitOverrideResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteVoiceMessageSpendLimitOverride(request))
  def setTextMessageSpendLimitOverride(
      request: zio.aws.pinpointsmsvoicev2.model.SetTextMessageSpendLimitOverrideRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.SetTextMessageSpendLimitOverrideResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.setTextMessageSpendLimitOverride(request))
  def associateOriginationIdentity(
      request: zio.aws.pinpointsmsvoicev2.model.AssociateOriginationIdentityRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.AssociateOriginationIdentityResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.associateOriginationIdentity(request))
  def updateEventDestination(
      request: zio.aws.pinpointsmsvoicev2.model.UpdateEventDestinationRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.UpdateEventDestinationResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateEventDestination(request))
  def describeOptedOutNumbers(
      request: zio.aws.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    StreamingOutputResult[
      Any,
      zio.aws.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse.ReadOnly,
      zio.aws.pinpointsmsvoicev2.model.OptedOutNumberInformation.ReadOnly
    ]
  ] = ZIO.serviceWithZIO(_.describeOptedOutNumbers(request))
  def describeOptedOutNumbersPaginated(
      request: zio.aws.pinpointsmsvoicev2.model.DescribeOptedOutNumbersRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.DescribeOptedOutNumbersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeOptedOutNumbersPaginated(request))
  def setDefaultMessageType(
      request: zio.aws.pinpointsmsvoicev2.model.SetDefaultMessageTypeRequest
  ): ZIO[
    zio.aws.pinpointsmsvoicev2.PinpointSmsVoiceV2,
    AwsError,
    zio.aws.pinpointsmsvoicev2.model.SetDefaultMessageTypeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.setDefaultMessageType(request))
}
