package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.{LogGroupArn, IamRoleArn}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CloudWatchLogsDestination(
    iamRoleArn: IamRoleArn,
    logGroupArn: LogGroupArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.CloudWatchLogsDestination = {
    import CloudWatchLogsDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.CloudWatchLogsDestination
      .builder()
      .iamRoleArn(IamRoleArn.unwrap(iamRoleArn): java.lang.String)
      .logGroupArn(LogGroupArn.unwrap(logGroupArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.CloudWatchLogsDestination.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.CloudWatchLogsDestination
      .wrap(buildAwsValue())
}
object CloudWatchLogsDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.CloudWatchLogsDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.CloudWatchLogsDestination =
      zio.aws.pinpointsmsvoicev2.model
        .CloudWatchLogsDestination(iamRoleArn, logGroupArn)
    def iamRoleArn: IamRoleArn
    def logGroupArn: LogGroupArn
    def getIamRoleArn: ZIO[Any, Nothing, IamRoleArn] = ZIO.succeed(iamRoleArn)
    def getLogGroupArn: ZIO[Any, Nothing, LogGroupArn] =
      ZIO.succeed(logGroupArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.CloudWatchLogsDestination
  ) extends zio.aws.pinpointsmsvoicev2.model.CloudWatchLogsDestination.ReadOnly {
    override val iamRoleArn: IamRoleArn =
      zio.aws.pinpointsmsvoicev2.model.primitives.IamRoleArn(impl.iamRoleArn())
    override val logGroupArn: LogGroupArn =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .LogGroupArn(impl.logGroupArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.CloudWatchLogsDestination
  ): zio.aws.pinpointsmsvoicev2.model.CloudWatchLogsDestination.ReadOnly =
    new Wrapper(impl)
}
