package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.FilterValue
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ConfigurationSetFilter(
    name: zio.aws.pinpointsmsvoicev2.model.ConfigurationSetFilterName,
    values: Iterable[FilterValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.ConfigurationSetFilter = {
    import ConfigurationSetFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.ConfigurationSetFilter
      .builder()
      .name(name.unwrap)
      .values(values.map { item =>
        FilterValue.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.ConfigurationSetFilter.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.ConfigurationSetFilter
      .wrap(buildAwsValue())
}
object ConfigurationSetFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.ConfigurationSetFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.pinpointsmsvoicev2.model.ConfigurationSetFilter =
      zio.aws.pinpointsmsvoicev2.model.ConfigurationSetFilter(name, values)
    def name: zio.aws.pinpointsmsvoicev2.model.ConfigurationSetFilterName
    def values: List[FilterValue]
    def getName: ZIO[
      Any,
      Nothing,
      zio.aws.pinpointsmsvoicev2.model.ConfigurationSetFilterName
    ] = ZIO.succeed(name)
    def getValues: ZIO[Any, Nothing, List[FilterValue]] = ZIO.succeed(values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.ConfigurationSetFilter
  ) extends zio.aws.pinpointsmsvoicev2.model.ConfigurationSetFilter.ReadOnly {
    override val name
        : zio.aws.pinpointsmsvoicev2.model.ConfigurationSetFilterName =
      zio.aws.pinpointsmsvoicev2.model.ConfigurationSetFilterName
        .wrap(impl.name())
    override val values: List[FilterValue] = impl
      .values()
      .asScala
      .map { item =>
        zio.aws.pinpointsmsvoicev2.model.primitives.FilterValue(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.ConfigurationSetFilter
  ): zio.aws.pinpointsmsvoicev2.model.ConfigurationSetFilter.ReadOnly =
    new Wrapper(impl)
}
