package zio.aws.pinpointsmsvoicev2.model
import zio.ZIO
import zio.aws.pinpointsmsvoicev2.model.primitives.{
  ClientToken,
  ConfigurationSetName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateConfigurationSetRequest(
    configurationSetName: ConfigurationSetName,
    tags: Optional[Iterable[zio.aws.pinpointsmsvoicev2.model.Tag]] =
      Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateConfigurationSetRequest = {
    import CreateConfigurationSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateConfigurationSetRequest
      .builder()
      .configurationSetName(
        ConfigurationSetName.unwrap(configurationSetName): java.lang.String
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.CreateConfigurationSetRequest.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.CreateConfigurationSetRequest
      .wrap(buildAwsValue())
}
object CreateConfigurationSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateConfigurationSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointsmsvoicev2.model.CreateConfigurationSetRequest =
      zio.aws.pinpointsmsvoicev2.model.CreateConfigurationSetRequest(
        configurationSetName,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken.map(value => value)
      )
    def configurationSetName: ConfigurationSetName
    def tags: Optional[List[zio.aws.pinpointsmsvoicev2.model.Tag.ReadOnly]]
    def clientToken: Optional[ClientToken]
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetName] =
      ZIO.succeed(configurationSetName)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.pinpointsmsvoicev2.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateConfigurationSetRequest
  ) extends zio.aws.pinpointsmsvoicev2.model.CreateConfigurationSetRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetName =
      zio.aws.pinpointsmsvoicev2.model.primitives
        .ConfigurationSetName(impl.configurationSetName())
    override val tags
        : Optional[List[zio.aws.pinpointsmsvoicev2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpointsmsvoicev2.model.Tag.wrap(item)
          }.toList
        )
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.ClientToken(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateConfigurationSetRequest
  ): zio.aws.pinpointsmsvoicev2.model.CreateConfigurationSetRequest.ReadOnly =
    new Wrapper(impl)
}
