package zio.aws.pinpointsmsvoicev2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.pinpointsmsvoicev2.model.primitives.{
  Timestamp,
  ConfigurationSetName
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class CreateConfigurationSetResponse(
    configurationSetArn: Optional[String] = Optional.Absent,
    configurationSetName: Optional[ConfigurationSetName] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.pinpointsmsvoicev2.model.Tag]] =
      Optional.Absent,
    createdTimestamp: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateConfigurationSetResponse = {
    import CreateConfigurationSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateConfigurationSetResponse
      .builder()
      .optionallyWith(
        configurationSetArn.map(value => value: java.lang.String)
      )(_.configurationSetArn)
      .optionallyWith(
        configurationSetName.map(value =>
          ConfigurationSetName.unwrap(value): java.lang.String
        )
      )(_.configurationSetName)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .build()
  }
  def asReadOnly
      : zio.aws.pinpointsmsvoicev2.model.CreateConfigurationSetResponse.ReadOnly =
    zio.aws.pinpointsmsvoicev2.model.CreateConfigurationSetResponse
      .wrap(buildAwsValue())
}
object CreateConfigurationSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateConfigurationSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.pinpointsmsvoicev2.model.CreateConfigurationSetResponse =
      zio.aws.pinpointsmsvoicev2.model.CreateConfigurationSetResponse(
        configurationSetArn.map(value => value),
        configurationSetName.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createdTimestamp.map(value => value)
      )
    def configurationSetArn: Optional[String]
    def configurationSetName: Optional[ConfigurationSetName]
    def tags: Optional[List[zio.aws.pinpointsmsvoicev2.model.Tag.ReadOnly]]
    def createdTimestamp: Optional[Timestamp]
    def getConfigurationSetArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("configurationSetArn", configurationSetArn)
    def getConfigurationSetName: ZIO[Any, AwsError, ConfigurationSetName] =
      AwsError.unwrapOptionField("configurationSetName", configurationSetName)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.pinpointsmsvoicev2.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateConfigurationSetResponse
  ) extends zio.aws.pinpointsmsvoicev2.model.CreateConfigurationSetResponse.ReadOnly {
    override val configurationSetArn: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.configurationSetArn())
      .map(value => value: String)
    override val configurationSetName: Optional[ConfigurationSetName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationSetName())
        .map(value =>
          zio.aws.pinpointsmsvoicev2.model.primitives
            .ConfigurationSetName(value)
        )
    override val tags
        : Optional[List[zio.aws.pinpointsmsvoicev2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.pinpointsmsvoicev2.model.Tag.wrap(item)
          }.toList
        )
    override val createdTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTimestamp())
      .map(value =>
        zio.aws.pinpointsmsvoicev2.model.primitives.Timestamp(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.pinpointsmsvoicev2.model.CreateConfigurationSetResponse
  ): zio.aws.pinpointsmsvoicev2.model.CreateConfigurationSetResponse.ReadOnly =
    new Wrapper(impl)
}
